% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.spmodel}
\alias{residuals.spmodel}
\alias{residuals.splm}
\alias{resid.splm}
\alias{residuals.spautor}
\alias{resid.spautor}
\alias{rstandard.splm}
\alias{rstandard.spautor}
\title{Extract fitted model residuals}
\usage{
\method{residuals}{splm}(object, type = "response", ...)

\method{resid}{splm}(object, type = "response", ...)

\method{residuals}{spautor}(object, type = "response", ...)

\method{resid}{spautor}(object, type = "response", ...)

\method{rstandard}{splm}(model, ...)

\method{rstandard}{spautor}(model, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{type}{\code{"response"} for response residuals, \code{"pearson"}
for Pearson residuals, or \code{"standardized"} for standardized residuals.
The default is \code{"response"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{model}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}
}
\value{
The residuals as a numeric vector.
}
\description{
Extract residuals from a fitted model object.
\code{resid} is an alias.
}
\details{
The response residuals are taken as the response minus the fitted values
for the response: \eqn{y - X \hat{\beta}}. The Pearson residuals are the
response residuals pre-multiplied by their square (Cholesky) root.
The standardized residuals are Pearson residuals divided by the square
root of one minus the leverage (hat) value. The standardized residuals are often used to
check model assumptions, as they have mean zero and variance approximately one.

\code{rstandard()} is an alias for \code{residuals(model, type = "standardized")}.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
residuals(spmod)
resid(spmod)
residuals(spmod, type = "pearson")
residuals(spmod, type = "standardized")
rstandard(spmod)
}
