% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.spmodel}
\alias{augment.spmodel}
\alias{augment.splm}
\alias{augment.spautor}
\title{Augment data with information from fitted model objects}
\usage{
\method{augment}{splm}(
  x,
  drop = TRUE,
  newdata = NULL,
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  ...
)

\method{augment}{spautor}(
  x,
  drop = TRUE,
  newdata = NULL,
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  ...
)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{drop}{A logical indicating whether to drop extra variables in the
fitted model object \code{x} when augmenting. The default for \code{drop} is \code{TRUE}.
\code{drop} is ignored if augmenting \code{newdata}.}

\item{newdata}{A data frame or tibble containing observations requiring prediction.
All of the original explanatory variables used to create the fitted model object \code{x}
must be present in \code{newdata}. Defaults to \code{NULL}, which indicates
that nothing has been passed to \code{newdata}.}

\item{se_fit}{Logical indicating whether or not a \code{.se.fit} column should
be added to augmented output. Passed to \code{predict()} and
defaults to \code{FALSE}.}

\item{interval}{Character indicating the type of confidence interval columns to
add to the augmented \code{newdata} output. Passed to \code{predict()} and defaults
to \code{"none"}.}

\item{...}{Additional arguments to \code{predict()} when augmenting \code{newdata}.}
}
\value{
When augmenting the original data set, a tibble with additional columns
\itemize{
\item{\code{.fitted}}{ Fitted value}
\item{\code{.resid}}{ Response residual (the difference between observed and fitted values)}
\item{\code{.hat}}{ Leverage (diagonal of the hat matrix)}
\item{\code{.cooksd}}{ Cook's distance}
\item{\code{.std.resid}}{ Standardized residuals}
\item{\code{.se.fit}}{ Standard error of the fitted value.}
}

When augmenting a new data set, a tibble with additional columns
\itemize{
\item{\code{.fitted}}{ Predicted (or fitted) value}
\item{\code{.lower}}{ Lower bound on interval}
\item{\code{.upper}}{ Upper bound on interval}
\item{\code{.se.fit}}{ Standard error of the predicted (or fitted) value}
}
}
\description{
Augment accepts a fitted model object and a data set and adds
information about each observation in the data set. New columns always
begin with a \code{.} prefix to avoid overwriting columns in the original
data set.

Augment behaves differently depending on whether the original data or new data
requires augmenting. Typically, when augmenting the original data, only the fitted
model object is specified, and when augmenting new data, the fitted model object
and \code{newdata} is specified. When augmenting the original data, diagnostic
statistics are augmented to each row in the data set. When augmenting new data,
predictions and optional intervals or standard errors are augmented to each
row in the new data set.
}
\details{
\code{augment()} returns a tibble with the same class as
\code{data}. That is, if \code{data} is
an \code{sf} object, then the augmented object (obtained via \code{augment(x)})
will be an \code{sf} object as well. When augmenting \code{newdata}, the
augmented object has the same class as \code{data}.

Missing response values from the original data can be augmented as if
they were a \code{newdata} object by providing \code{x$newdata} to the
\code{newdata} argument (where \code{x} is the name of the fitted model
object). This is the only way to compute predictions for
\code{\link[=spautor]{spautor()}} fitted model objects.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
augment(spmod)
spmod_sulf <- splm(sulfate ~ 1, data = sulfate, spcov_type = "exponential")
augment(spmod_sulf)
augment(spmod_sulf, newdata = sulfate_preds)
# missingness in original data
spmod_seal <- spautor(log_trend ~ 1, data = seal, spcov_type = "car")
augment(spmod_seal)
augment(spmod_seal, newdata = spmod_seal$newdata)
}
\seealso{
\code{\link[=tidy.spmodel]{tidy.spmodel()}} \code{\link[=glance.spmodel]{glance.spmodel()}}
}
