% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcov_params.R
\name{spcov_params}
\alias{spcov_params}
\title{Create a spatial covariance parameter object}
\usage{
spcov_params(spcov_type, de, ie, range, extra, rotate = 0, scale = 1)
}
\arguments{
\item{spcov_type}{The spatial covariance function type. Available options include
\code{"exponential"}, \code{"spherical"}, \code{"gaussian"},
\code{"triangular"}, \code{"circular"}, \code{"cubic"},
\code{"pentaspherical"}, \code{"cosine"}, \code{"wave"},
\code{"jbessel"}, \code{"gravity"}, \code{"rquad"},
\code{"magnetic"}, \code{"matern"}, \code{"cauchy"}, \code{"pexponential"},
\code{"car"}, \code{"sar"}, and \code{"none"}.}

\item{de}{The spatially dependent (correlated) random error variance. Commonly referred to as
a partial sill.}

\item{ie}{The spatially independent (uncorrelated) random error variance. Commonly referred to as
a nugget.}

\item{range}{The correlation parameter.}

\item{extra}{An extra covariance parameter used when \code{spcov_type} is
\code{"matern"}, \code{"cauchy"}, \code{"pexponential"}, \code{"car"}, or
\code{"sar"}.}

\item{rotate}{Anisotropy rotation parameter (from 0 to \eqn{\pi} radians).
A value of 0 (the default) implies no rotation.
Not used if \code{spcov_type} is \code{"car"} or \code{"sar"}.}

\item{scale}{Anisotropy scale parameter (from 0 to 1).
A value of 1 (the default) implies no scaling.
Not used if \code{spcov_type} is \code{"car"} or \code{"sar"}.}
}
\value{
A named numeric vector of spatial covariance parameters with class \code{spcov_type}.
}
\description{
Create a spatial covariance parameter object for use with other
functions.
}
\details{
Generally, all arguments to \code{spcov_params} must be specified, though
default arguments are often chosen based on \code{spcov_type}.
When \code{spcov_type} is \code{car} or
\code{sar}, \code{ie} is assumed to be 0 unless specified otherwise.
For full parameterizations of all spatial covariance
functions, see \code{\link[=spcov_initial]{spcov_initial()}}.
}
\examples{
spcov_params("exponential", de = 1, ie = 1, range = 1)
}
