% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acpc_reorient.R
\name{acpc_reorient}
\alias{acpc_reorient}
\title{AC/PC Reorientation}
\usage{
acpc_reorient(infiles, modality = c("T1", "T2", "CT", "fMRI"),
  spmdir = spm_dir(), verbose = TRUE, install_dir = NULL, ...)
}
\arguments{
\item{infiles}{(character) Files to reorient.
First file will be used to
estimate AC/PC, then rest will be transformed}

\item{modality}{T1, T2, CT, fMRI (T2*)}

\item{spmdir}{(character) path for SPM12.  If NULL, assumes
SPM12 is in matlabpath and so is spm8/toolbox
Must have nii_setOrigin installed.  In
\code{system.file("", package="spm12r")} from
http://www.mccauslandcenter.sc.edu/CRNL/sw/spm8/spm.zip}

\item{verbose}{(logical) Print diagnostic output}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments to pass to \code{\link{run_matlab_code}}}
}
\value{
Exit code from MATLAB.  If not zero, there was an error
}
\description{
Function that AC/PC re-orients the images for SPM
spatial normalization routine.  Uses nii_setOrigin from
http://www.mccauslandcenter.sc.edu/CRNL/sw/spm8/spm.zip
}
