% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_batch_spm12_coregister.R
\name{build_spm12_coregister}
\alias{build_spm12_coregister}
\alias{build_spm12_coregister_estimate}
\alias{build_spm12_coregister_reslice}
\alias{spm12_coregister_wrapper}
\alias{spm12_coregister}
\alias{spm12_coregister_estimate}
\alias{spm12_coregister_reslice}
\title{Batch SPM12 Coregister (Estimate and Reslice)}
\usage{
build_spm12_coregister(fixed, moving, other.files = NULL,
  cost_fun = c("nmi", "ecc", "ncc"), separation = c(4, 2),
  tol = c(0.02, 0.02, 0.02, 0.001, 0.001, 0.001, 0.01, 0.01, 0.01, 0.001,
  0.001, 0.001), fwhm = c(7, 7), interp = c("bspline4",
  "nearestneighbor", "trilinear", paste0("bspline", 2:3), paste0("bspline",
  5:7)), wrap_x = FALSE, wrap_y = FALSE, wrap_z = FALSE,
  mask = FALSE, prefix = "r", verbose = TRUE, ...)

build_spm12_coregister_estimate(fixed, moving, other.files = NULL,
  cost_fun = c("nmi", "ecc", "ncc"), separation = c(4, 2),
  tol = c(0.02, 0.02, 0.02, 0.001, 0.001, 0.001, 0.01, 0.01, 0.01, 0.001,
  0.001, 0.001), fwhm = c(7, 7), verbose = TRUE, ...)

build_spm12_coregister_reslice(fixed, moving, interp = c("bspline4",
  "nearestneighbor", "trilinear", paste0("bspline", 2:3), paste0("bspline",
  5:7)), wrap_x = FALSE, wrap_y = FALSE, wrap_z = FALSE,
  mask = FALSE, prefix = "r", verbose = TRUE, ...)

spm12_coregister_wrapper(..., func = c("build_spm12_coregister",
  "build_spm12_coregister_reslice", "build_spm12_coregister_estimate"),
  add_spm_dir = TRUE, spmdir = spm_dir(verbose = verbose, install_dir =
  install_dir), clean = TRUE, verbose = TRUE, outdir = NULL,
  install_dir = NULL)

spm12_coregister(..., add_spm_dir = TRUE, spmdir = spm_dir(verbose =
  verbose, install_dir = install_dir), clean = TRUE, verbose = TRUE,
  outdir = NULL, install_dir = NULL)

spm12_coregister_estimate(..., add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE, verbose = TRUE, outdir = NULL, install_dir = NULL)

spm12_coregister_reslice(..., add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE, verbose = TRUE, outdir = NULL, install_dir = NULL)
}
\arguments{
\item{fixed}{File that is assumed fixed}

\item{moving}{moving file to be registered to fixed space}

\item{other.files}{Other files to register to fixed, 
in same space as moving file}

\item{cost_fun}{Cost function}

\item{separation}{The  average  distance  between  sampled 
points (in mm).  
Can be a vector to allow a coarse registration followed by 
increasingly fine}

\item{tol}{The  accuracy  for  each  parameter.    Iterations
stop  when 
 differences  between  successive  estimates  are  less  than  
 the required}

\item{fwhm}{Gaussian  smoothing  to  apply  to  the 256x256 
joint histogram. 
Other information theoretic coregistration methods use fewer bins,}

\item{interp}{Interpolator for sampling in fixed space}

\item{wrap_x}{wrap in x-direction}

\item{wrap_y}{wrap in y-direction}

\item{wrap_z}{wrap in z-direction}

\item{mask}{Mask the data.  With masking enabled, 
the program searches 
through the whole time series looking for voxels which need to
 be sampled 
from outside  the  original  images.  Where  this  occurs, 
 that  voxel is set to zero for the whole set of images}

\item{prefix}{Prefix to append to front of image filename}

\item{verbose}{Print diagnostic messages}

\item{...}{Additional arguments to pass to 
\code{\link{run_matlabbatch}}}

\item{func}{not used}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{outdir}{Directory to copy results.  If full filename 
given, then results will
be in \code{dirname(filename)}}

\item{install_dir}{directory to download SPM12}
}
\value{
List of output files, the \code{matlabbatch} object, 
and the script
}
\description{
Performs SPM12 coregistration estimation and 
reslicing on an Image
}
\examples{
\dontrun{
fname = paste0("~/Desktop/D2/scratch/", 
"100-318_20070723_0957_CT_3_CT_Head-_SS_0.01_SyN_ROI.nii.gz")
spm = spm12_coregister(
fixed = fname,
moving = fname, 
other.files = fname,
execute = FALSE)
}
if (matlabr::have_matlab()) {
install_dir = tempdir()
dims = rep(10, 3)
fixed = array(rnorm(prod(dims)), dim = dims)
fixed = oro.nifti::nifti(fixed)
moving = array(rnorm(prod(dims)), dim = dims)
moving = oro.nifti::nifti(moving) 
res = build_spm12_coregister(
fixed = fixed, moving = moving,
install_dir = install_dir)
}
}
