% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiro_raw.R
\name{spiro_raw}
\alias{spiro_raw}
\alias{spiro_raw.default}
\alias{spiro_raw.spiro}
\title{Get raw data from a metabolic cart file or an imported spiro object}
\usage{
spiro_raw(data, device = NULL, anonymize = TRUE)

\method{spiro_raw}{default}(data, device = NULL, anonymize = TRUE)

\method{spiro_raw}{spiro}(data, device = NULL, anonymize = TRUE)
}
\arguments{
\item{data}{Either the absolute or relative path of the file that contains
the gas exchange data, or a data frame of the class \code{spiro}, usually
the output of the \code{\link{spiro}} function.}

\item{device}{A character string, specifying the device for measurement. By
default the device type is guessed by the characteristics of the
\code{file}. This can be overridden by setting the argument to
\code{"cortex"}, \code{"cosmed"}, \code{"vyntus"} or \code{"zan"}.}

\item{anonymize}{Whether meta data should be anonymized during import.
Defaults to TRUE. See \code{\link{get_anonid}} for more information.}
}
\value{
A \code{data.frame} with data. The attribute \code{info} contains
addition meta-data retrieved from the original file.
}
\description{
\code{spiro_raw()} retrieves cardiopulmonary raw data from various types of
metabolic cart files, or from objects previously imported and processed with
\code{\link{spiro}}.
}
\details{
The default way of importing data into the spiro package is using the
\code{\link{spiro}} function. Besides importing this will perform further
processing steps such as the interpolation of data or the calculation of
additional variables. But in some cases the original raw data may be
preferable compared to the processed raw data. \code{spiro_raw} can either
retrieve the raw data from an already imported data set or from a new raw
data file.
}
\section{Methods (by class)}{
\itemize{
\item \code{spiro_raw(default)}: Method for direct import from metabolic cart raw data
file

\item \code{spiro_raw(spiro)}: Method for objects of class \code{spiro}, usually files
previously imported and processed with \code{\link{spiro}}

}}
\examples{
# Get example data
file <- spiro_example("zan_gxt")

# direct import of raw data
out <- spiro_raw(file)
head(out)

# retrieval of raw data from previously processed object
s <- spiro(file)
out2 <- spiro_raw(s)
head(out2)
}
