% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_protocol.R
\name{set_protocol}
\alias{set_protocol}
\alias{pt_pre}
\alias{pt_wu}
\alias{pt_steps}
\alias{pt_const}
\title{Setting an exercise testing profile}
\usage{
set_protocol(...)

pt_pre(duration)

pt_wu(duration, load, rest.duration = 0)

pt_steps(duration, load, increment, count, rest.duration = 0)

pt_const(duration, load, count, rest.duration = 0)
}
\arguments{
\item{...}{Functions related to sections of the load profile, such as
\code{pt_pre}, \code{pt_wu}, \code{pt_const} or \code{pt_step}. Sections
will be evaluated in the order they are entered.}

\item{duration}{A number, giving the duration of the test section or
a single load within the test section (in seconds).}

\item{load}{A number, giving the (initial) load of a section.}

\item{rest.duration}{A number, specifying the duration of (each) rest (in
seconds).}

\item{increment}{A number, giving the difference in load between the current
and the following load step.}

\item{count}{An integer for the number of load sections.}
}
\value{
A \code{data.frame} with the duration and load of each protocol step.
}
\description{
\code{set_protocol()} allows to set an load profile for an exercise test
based on profile sections.
}
\section{Functions}{
\itemize{
\item \code{pt_pre()}: Add pre-measures to a load protocol

\item \code{pt_wu()}: Add a warm up to a load protocol

\item \code{pt_steps()}: Add a stepwise load protocol

\item \code{pt_const()}: Add a constant load protocol

}}
\examples{
set_protocol(pt_pre(60), pt_wu(300, 100), pt_steps(180, 150, 25, 8, 30))
}
\seealso{
\link{set_protocol_manual} For manual protocol design.

\link{get_protocol} For automated extracting of protocols from raw data.
}
