% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/th_indep.R
\name{th.indep}
\alias{th.indep}
\title{Spatial threshold-independent accuracy measures}
\usage{
th.indep(data, coord, spatial = TRUE, plot.ROC = TRUE)
}
\arguments{
\item{data}{A data frame or matrix with two columns. The first column
should contain actual presence/absence data (binary, 0 or 1) and the
second column should contain model predictions of probability of
occurence (numeric, between 0 and 1).}

\item{coord}{A data frame or matrix with two columns containing x,y
coordinates for each actual and predicted value. Coordinates must be
integer and consecutively numbered.}

\item{spatial}{A logical value indicating whether spatial corrected
indices (rather than classical indices) should be computed}

\item{plot.ROC}{A logical indicating whether the ROC should be plotted}
}
\value{
A list with the following components:
\describe{
 \item{\code{AUC}}{Area under curve}
 \item{\code{TSS}}{Maximum TSS value}
 \item{\code{sensitivity}}{Sensitivity}
 \item{\code{Specificity}}{Specificity}
}
}
\description{
Calculates spatially corrected, threshold-independent metrics for
an observational data set and model predictions (AUC, ROC, max-TSS)
}
\examples{
data(hook)
data<-hook[,1:2]
coord<-hook[,3:4]
si2<-th.indep(data,coord,spatial=TRUE)
si2$AUC
si2$TSS

}
\references{
Carl G, Kuehn I (2016)
Spind: a package for computing spatially corrected accuracy measures.
Ecography. DOI: 10.1111/ecog.02593
}
\seealso{
\code{\link{th.dep}}
}
\author{
Gudrun Carl
}
