\name{srf}
\alias{srf}
\title{Generate design for penalized surface estimation.}
\usage{
  srf(coords, K = min(50, sum(nd)/4), rankZ = 0.999,
  centerBase = TRUE, baseType = c("B", "thinPlate"),
  decomposition = c("ortho", "MM", "asIs"), tol = 1e-10)
}
\arguments{
  \item{coords}{a \code{data.frame} with two columns
  containing the coordinates}

  \item{K}{(approximate) number of basis functions in the
  original basis (defaults to 50). If \code{baseType="B"}
  you can specify a vector giving the number of marginal
  basis functions in each direction.}

  \item{rankZ}{how many eigenvectors to retain from the
  eigen decomposition: either a number > 3 or the
  proportion of the sum of eigenvalues the retained
  eigenvectors must represent at least. Defaults to .999.}

  \item{centerBase}{project the basis of the penalized part
  into the complement of the column space of the basis of
  the unpenalized part? defaults to TRUE}

  \item{baseType}{Defaults to \code{"B"}, i.e. a tensor
  product basis based on marginal cubic B-splines with
  ridge penalty (i.e. penalizing deviations from the
  constant). Set to \code{"thinPlate"} if cubic thin plate
  splines are desired, see note below.}

  \item{decomposition}{use a (truncated) spectral
  decomposition of the implied prior covariance of
  \eqn{f(x,y)} for a low rank representation with
  orthogonal basis functions and i.i.d. coefficients
  (\code{"ortho"}), or use the mixed model
  reparameterization for non-orthogonal basis functions and
  i.i.d. coefficients (\code{"MM"}) or use basis functions
  as they are with i.i.d. coefficients (\code{"asIs"}).
  Defaults to \code{"ortho"}.}

  \item{tol}{count eigenvalues smaller than this as zero}
}
\value{
  a design matrix for the 2-D spline.
}
\description{
  This function generates the design for a 2-D penalized
  spline using (almost) radial basis functions. Use this
  type of term to account for \emph{spatial} variation.
  Smooth interactions between covariates are often better
  fitted via the interactions of \code{\link{lin}} and
  \code{\link{sm}} terms, because they allow a
  decomposition into (linear and smooth) marginal trends
  and (linear-linear, linear-smooth/"varying coefficients",
  and smooth-smooth) interactions. This decomposition
  usually makes no sense for spatial data.
}
\details{
  Note that \code{srf()} expects \code{coords} to be a
  \code{data.frame} within the larger \code{data.frame}
  supplied to \code{\link{spikeSlabGAM}} in its \code{data}
  argument, i.e. \code{coords} is considered a
  two-dimensional covariate.

  If \code{baseType} is \code{'thinPlate'}, knot locations
  for the thin plate spline basis are chosen via a
  space-filling algorithm (i.e. medoids returned by
  \code{\link[cluster]{clara}}) as suggested in
  Ruppert/Wand/Carroll, ch. 13.5. Since the thin plate
  penalty term penalizes deviations from a linear trend, it
  is recommended to add marginal linear trends and their
  interaction to the model if \code{baseType="thinPlate"}
  to improve the fit.
}
\note{
  TODO: prediction seems very unstable when extrapolating
  outside the convex hull, sometimes even nonsensical
  values inside conv.hull close to border - problem in
  akima::interp?
}
\author{
  Fabian Scheipl
}
\references{
  Ruppert, D., Wand, M.P., Carroll, R.J. (2003).
  Semiparametric Regression. Cambridge University Press
}

