% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclust.R
\name{tclust}
\alias{tclust}
\title{Clustering by a threshold}
\usage{
tclust(distobj, threshold = 0.01)
}
\arguments{
\item{distobj}{A distance object (usually from \code{\link{dist.dna}}).}

\item{threshold}{Distance cutoff for clustering. Default of 0.01 (1\%).}
}
\value{
A list with each element giving the index of the individuals
contained in each cluster.
}
\description{
Identifies clusters, excluding individuals greater than the threshold from
any member.
}
\details{
If two individuals are more distant than \code{threshold} from each other,
but both within \code{threshold} of a third, all three are contained in a
single cluster.
}
\examples{


data(anoteropsis)
anoSpp <- sapply(strsplit(dimnames(anoteropsis)[[1]], split="_"), 
	function(x) paste(x[1], x[2], sep="_"))
anoDist <- ape::dist.dna(anoteropsis)

tclust(anoDist)

#Names of individuals
anoClust <- tclust(anoDist)
lapply(anoClust, function(x) anoSpp[x])

}
\seealso{
\code{\link{dist.dna}}, \code{\link{localMinima}}. %% ~~objects to
See Also as \code{\link{help}}, ~~~
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Barcoding}
