% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cir_coord_conv}
\alias{cir_coord_conv}
\alias{Theta_to_X}
\alias{X_to_Theta}
\title{Transforming between polar and Cartesian coordinates}
\usage{
Theta_to_X(Theta)

X_to_Theta(X)
}
\arguments{
\item{Theta}{a \bold{matrix} of size \code{c(n, M)} with \code{M} samples
of size \code{n} of circular data on \eqn{[0, 2\pi)}. Must not contain
\code{NA}'s.}

\item{X}{an \bold{array} of size \code{c(n, 2, M)} containing the Cartesian
coordinates of \code{M} samples of size \code{n} of directions on
\eqn{S^{1}}. Must not contain \code{NA}'s.}
}
\value{
\itemize{
  \item \code{Theta_to_X}: the corresponding \code{X}.
  \item \code{X_to_Theta}: the corresponding \code{Theta}.
}
}
\description{
Transformation between a matrix \code{Theta} containing
\code{M} circular samples of size \code{n} on \eqn{[0, 2\pi)} and an array
\code{X} containing the associated Cartesian coordinates on
\eqn{S^1:=\{{\bf x}\in R^2:||{\bf x}||=1\}}{S^1:=\{x\in R^2:||x||=1\}}.
}
\examples{
# Sample
Theta <- r_unif_cir(n = 10, M = 2)
X <- r_unif_sph(n = 10, p = 2, M = 2)

# Check equality
sum(abs(X - Theta_to_X(X_to_Theta(X))))
sum(abs(Theta - X_to_Theta(Theta_to_X(Theta))))
}
