% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{plotVoronoiOnSphere}
\alias{plotVoronoiOnSphere}
\title{Plot spherical Voronoï tessellation}
\usage{
plotVoronoiOnSphere(
  vor,
  colors = "gradient",
  distinctArgs = list(seedcolors = c("#ff0000", "#00ff00", "#0000ff")),
  randomArgs = list(hue = "random", luminosity = "bright"),
  palette = "Rocket",
  bias = 1,
  edges = FALSE,
  sites = FALSE,
  ecolor = "black",
  lwd = 3,
  scolor = "black",
  sradius = NA,
  ...
)
}
\arguments{
\item{vor}{an output of \code{\link{VoronoiOnSphere}}}

\item{colors}{controls the filling colors of the triangles, either
\code{NA} for no color, or a single color, or \code{"random"} to get
multiple colors with \code{\link[colorsGen]{randomColor}}, or
\code{"distinct"} to get multiple colors with
\code{\link[Polychrome]{createPalette}}, or \code{"gradient"}}

\item{distinctArgs}{if \code{colors = "distinct"}, a list of arguments
passed to \code{\link[Polychrome]{createPalette}}}

\item{randomArgs}{if \code{colors = "random"}, a list of arguments passed
to \code{\link[colorsGen]{randomColor}}}

\item{palette}{this argument is used only when \code{colors="gradient"}; it
can be either a character vector of colors, or the name of a palette
which will be passed to the \code{palette} argument of the function
\code{\link[grDevices]{hcl.colors}}}

\item{bias}{this argument is used only when \code{colors="gradient"}; it
is passed to the \code{bias} argument of the function
\code{\link[grDevices]{colorRamp}}}

\item{edges}{Boolean, whether to plot the edges}

\item{sites}{Boolean, whether to plot the Voronoï sites}

\item{ecolor}{a color for the edges}

\item{lwd}{graphical parameter for the edges, if they are plotted}

\item{scolor}{a color for the sites}

\item{sradius}{a radius for the sites, which are plotted as spheres (if
they are plotted); \code{NA} for a default value}

\item{...}{arguments passed to \code{\link[rgl]{shade3d}} to plot the
spherical faces}
}
\value{
No value is returned.
}
\description{
Plot a spherical Voronoï tessellation.
}
\examples{
library(sphereTessellation)
library(rgl)
# take the vertices of the cuboctahedron and Voronoïze
vertices <- t(cuboctahedron3d()$vb[-4L, ])
vor <- VoronoiOnSphere(vertices)
# plot
open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.8)
plotVoronoiOnSphere(vor, specular = "black", edges = TRUE)

# effect of the `bias` argument ###
\donttest{library(sphereTessellation)
library(rgl)
vertices <- t(cuboctahedron3d()$vb[-4L, ])
vor <- VoronoiOnSphere(vertices)
open3d(windowRect = 50 + c(0, 0, 900, 300), zoom = 0.8)
mfrow3d(1, 3)
plotVoronoiOnSphere(vor, palette = "Viridis", bias = 0.5)
next3d()
plotVoronoiOnSphere(vor, palette = "Viridis", bias = 0.8)
next3d()
plotVoronoiOnSphere(vor, palette = "Viridis", bias = 1.1)}
}
