% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icosphere.R
\name{icosphereMesh}
\alias{icosphereMesh}
\title{Icosphere}
\usage{
icosphereMesh(x = 0, y = 0, z = 0, r = 1, iterations = 3L)
}
\arguments{
\item{x, y, z}{coordinates of the center}

\item{r}{radius}

\item{iterations}{number of iterations (the icosphere is obtained by
iteratively subdividing the faces of an icosahedron)}
}
\value{
A \strong{rgl} mesh (class \code{mesh3d}).
}
\description{
Returns the mesh of an icosphere.
}
\examples{
library(sphereTessellation)
library(rgl)
mesh <- icosphereMesh()
open3d(windowRect = 50 + c(0, 0, 512, 512))
shade3d(mesh, color = "navy")
}
