% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-people.R
\name{sample_households}
\alias{sample_households}
\title{Sample appropriate indices from household PUMS}
\usage{
sample_households(method, n_house, pums_h, pums_p = NULL, puma_id = NULL,
  place_id = NULL, marginals = NULL)
}
\arguments{
\item{method}{character indicating the method for sampling}

\item{n_house}{numeric indicating the number of households to sample}

\item{pums_h}{dataframe of the households we are sampling from}

\item{pums_p}{optionally include a dataframe of agents}

\item{puma_id}{vector indicating which specific puma in PUMS we are sampling 
from, if any}

\item{place_id}{unique code identifying the place}

\item{marginals}{optionally used for IPF or MM sampling}
}
\value{
numeric with the indicies of the household PUMS to sample
}
\description{
Sample appropriate indices from household PUMS
}
\examples{
data("tartanville")
example_place_id <- tartanville$pop_table$place_id[1] 
example_puma_id <- tartanville$pop_table$puma_id[1] 
example_n_house <- tartanville$pop_table$n_house[1] 
sample_households(method = "uniform", 
                  pums_h = tartanville$pums_h, 
                  pums_p = tartanville$pums_p, 
                  n_house = example_n_house, 
                  place_id = example_place_id, 
                  puma_id = example_puma_id)

}
