% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_misc.R
\name{as.resampling}
\alias{as.resampling}
\alias{resampling}
\alias{as.resampling_default}
\alias{as.resampling.default}
\alias{as.resampling.factor}
\alias{as.resampling_list}
\alias{as.resampling.list}
\alias{validate.resampling}
\alias{is.resampling}
\alias{print.resampling}
\title{Resampling objects such as partitionings or bootstrap samples}
\usage{
as.resampling(object, ...)

\method{as.resampling}{default}(object, ...)

\method{as.resampling}{factor}(object, ...)

\method{as.resampling}{list}(object, ...)

validate.resampling(object)

is.resampling(x, ...)

\method{print}{resampling}(x, ...)
}
\arguments{
\item{object}{depending on the function/method, a list or a vector of type
factor defining a partitioning of the dataset.}

\item{...}{currently not used.}

\item{x}{object of class \code{resampling}.}
}
\value{
\code{as.resampling} methods: An object of class \code{resampling}.
}
\description{
Create/coerce and print resampling objects, e.g., partitionings
or boostrap samples derived from a data set.
}
\details{
A \code{resampling} object is a list of lists defining a set of training
and test samples.

In the case of \code{k}-fold cross-validation partitioning, for example, the
corresponding \code{resampling} object would be of length \code{k}, i.e. contain \code{k}
lists. Each of these \code{k} lists defines a training set of size \code{n(k-1)/k}
(where \code{n} is the overall sample size), and a test set of size \code{n/k}. The
\code{resampling} object does, however, not contain the data itself, but only
indices between \code{1} and \code{n} identifying the selection (see Examples).

Another example is bootstrap resampling. \link{represampling_bootstrap} with
argument \code{oob = TRUE} generates \code{\link{rep}}\code{resampling} objects with indices of a
bootstrap sample in the \code{train} component and indices of the out-of-bag
sample in the test component (see Examples below).

\code{as.resampling.factor}: For each factor level of the input variable,
\code{as.resampling.factor} determines the indices of samples in this level (=
test samples) and outside this level (= training samples). Empty levels of
\code{object} are dropped without warning.

\code{as.resampling_list} checks if the list in \code{object} has a valid \code{resampling}
object structure (with components \code{train} and \code{test} etc.) and assigns the
class attribute \code{'resampling'} if successful.
}
\examples{
# Muenchow et al. (2012), see ?ecuador

# Partitioning by elevation classes in 200 m steps:
parti <- factor(as.character(floor(ecuador$dem / 200)))
smp <- as.resampling(parti)
summary(smp)
# Compare:
summary(parti)

# k-fold (non-spatial) cross-validation partitioning:
parti <- partition_cv(ecuador)
parti <- parti[[1]] # the first (and only) resampling object in parti
# data corresponding to the test sample of the first fold:
str(ecuador[parti[[1]]$test, ])
# the corresponding training sample - larger:
str(ecuador[parti[[1]]$train, ])

# Bootstrap training sets, out-of-bag test sets:
parti <- represampling_bootstrap(ecuador, oob = TRUE)
parti <- parti[[1]] # the first (and only) resampling object in parti
# out-of-bag test sample: approx. one-third of nrow(ecuador):
str(ecuador[parti[[1]]$test, ])
# bootstrap training sample: same size as nrow(ecuador):
str(ecuador[parti[[1]]$train, ])
}
\seealso{
\link{represampling}, \link{partition_cv},
\link{partition_kmeans}, \link{represampling_bootstrap}, etc.
}
