/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.swing;

import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.DLabel;
import bibliothek.gui.dock.util.swing.Rotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class OrientedLabel
extends BackgroundPanel {
    private DLabel label = new DLabel();
    private Font originalFont;
    private Icon icon;
    private int iconOffset = 2;
    private int iconTextDistance = 2;
    private boolean originalFontSet = false;
    private String text;
    private Rotation rotation = Rotation.DEGREE_0;

    public OrientedLabel() {
        super(false, false);
        this.setOpaque(false);
        this.label.setOpaque(false);
        this.label.setAlignmentX(0.0f);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.revalidate();
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIconOffset(int iconOffset) {
        this.iconOffset = iconOffset;
        this.revalidate();
        this.repaint();
    }

    public int getIconOffset() {
        return this.iconOffset;
    }

    public void setIconTextDistance(int iconTextDistance) {
        this.iconTextDistance = iconTextDistance;
        this.revalidate();
        this.repaint();
    }

    public int getIconTextDistance() {
        return this.iconTextDistance;
    }

    public void setRotation(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("rotation must not be null");
        }
        this.rotation = rotation;
        this.revalidate();
    }

    public void setHorizontal(boolean horizontal) {
        if (horizontal) {
            this.setRotation(Rotation.DEGREE_0);
        } else {
            this.setRotation(Rotation.DEGREE_90);
        }
    }

    public boolean isHorizontal() {
        return this.rotation == Rotation.DEGREE_0 || this.rotation == Rotation.DEGREE_180;
    }

    public boolean isVertical() {
        return !this.isHorizontal();
    }

    public void setText(String text) {
        this.text = text;
        this.label.setText(text == null || text.length() == 0 ? null : "  " + text);
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.label != null) {
            this.label.setBackground(bg);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.label != null) {
            this.originalFontSet = false;
            this.originalFont = null;
            this.label.setFont(null);
            this.label.updateUI();
            this.updateFonts();
        }
    }

    protected void updateFonts() {
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            if (!this.originalFontSet) {
                this.originalFontSet = true;
                this.originalFont = this.label.getFont();
            }
            if (font != null) {
                this.label.setFont(font);
            } else {
                this.label.setFont(this.originalFont);
                this.originalFont = null;
                this.originalFontSet = false;
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setFontModifier(FontModifier modifier) {
        this.label.setFontModifier(modifier);
        this.revalidate();
        this.repaint();
    }

    public FontModifier getFontModifier() {
        return this.label.getFontModifier();
    }

    public DLabel getLabel() {
        return this.label;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = this.label.getPreferredSize();
        if (this.isHorizontal()) {
            if (this.icon == null) {
                return new Dimension(size.width + 5, size.height);
            }
            return new Dimension(size.width + 5 + this.iconOffset + this.iconTextDistance + this.icon.getIconWidth(), Math.max(size.height, this.icon.getIconHeight() + 2 * this.iconOffset));
        }
        if (this.icon == null) {
            return new Dimension(size.height, size.width + 5);
        }
        return new Dimension(Math.max(size.height, this.icon.getIconWidth() + 2 * this.iconOffset), size.width + 5 + this.iconOffset + this.iconTextDistance + this.icon.getIconHeight());
    }

    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    public void paintForeground(Graphics g) {
        if (this.rotation == Rotation.DEGREE_0) {
            if (this.icon == null) {
                this.label.paint(g);
            } else {
                int width = this.getWidth();
                int height = this.getHeight();
                int iconWidth = this.icon.getIconWidth();
                int iconHeight = this.icon.getIconHeight();
                this.icon.paintIcon(this, g, this.iconOffset, (height - iconHeight) / 2);
                int usedUp = iconWidth + this.iconOffset + this.iconTextDistance;
                if (usedUp < width) {
                    g = g.create(usedUp, 0, width - usedUp, height);
                    this.label.paint(g);
                    g.dispose();
                }
            }
        } else if (this.rotation == Rotation.DEGREE_90) {
            double angle = 1.5707963267948966;
            if (this.icon == null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.rotate(angle, 0.0, 0.0);
                g2.translate(0, -this.getWidth());
                this.label.paint(g2);
                g2.dispose();
            } else {
                int width = this.getWidth();
                int height = this.getHeight();
                int iconWidth = this.icon.getIconWidth();
                int iconHeight = this.icon.getIconHeight();
                this.icon.paintIcon(this, g, (width - iconWidth) / 2, this.iconOffset);
                int usedUp = iconHeight + this.iconOffset + this.iconTextDistance;
                if (usedUp < height) {
                    Graphics2D g2 = (Graphics2D)g.create(0, usedUp, width, height - usedUp);
                    g2.rotate(angle, 0.0, 0.0);
                    g2.translate(0, -this.getWidth());
                    this.label.paint(g2);
                    g2.dispose();
                }
            }
        } else if (this.rotation == Rotation.DEGREE_180) {
            double angle = Math.PI;
            if (this.icon == null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.rotate(angle, 0.0, 0.0);
                g2.translate(-this.getWidth(), -this.getHeight());
                this.label.paint(g2);
                g2.dispose();
            } else {
                int width = this.getWidth();
                int height = this.getHeight();
                int iconWidth = this.icon.getIconWidth();
                int iconHeight = this.icon.getIconHeight();
                this.icon.paintIcon(this, g, this.iconOffset, (height - iconHeight) / 2);
                int usedUp = iconWidth + this.iconOffset + this.iconTextDistance;
                if (usedUp < width) {
                    Graphics2D g2 = (Graphics2D)g.create(usedUp, 0, width - usedUp, height);
                    g2.rotate(angle, 0.0, 0.0);
                    g2.translate(-width + usedUp, height);
                    this.label.paint(g2);
                    g2.dispose();
                }
            }
        } else {
            double angle = 4.71238898038469;
            if (this.icon == null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.rotate(angle, 0.0, 0.0);
                g2.translate(-this.getHeight(), 0);
                this.label.paint(g2);
                g2.dispose();
            } else {
                int width = this.getWidth();
                int height = this.getHeight();
                int iconWidth = this.icon.getIconWidth();
                int iconHeight = this.icon.getIconHeight();
                this.icon.paintIcon(this, g, (width - iconWidth) / 2, this.iconOffset);
                int usedUp = iconHeight + this.iconOffset + this.iconTextDistance;
                if (usedUp < height) {
                    Graphics2D g2 = (Graphics2D)g.create(0, usedUp, width, height - usedUp);
                    g2.rotate(angle, 0.0, 0.0);
                    g2.translate(-height, 0);
                    this.label.paint(g2);
                    g2.dispose();
                }
            }
        }
    }

    public void update(Graphics g) {
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.isHorizontal()) {
            this.label.setBounds(0, 0, w, h);
        } else {
            this.label.setBounds(0, 0, h, w);
        }
    }
}

