/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action.panel;

import bibliothek.gui.dock.common.action.panel.PanelPopupWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindowListener;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPanelPopupWindow
implements PanelPopupWindow {
    private List<PanelPopupWindowListener> listeners = new ArrayList<PanelPopupWindowListener>();

    public void addListener(PanelPopupWindowListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(PanelPopupWindowListener listener) {
        this.listeners.remove(listener);
    }

    protected PanelPopupWindowListener[] listeners() {
        return this.listeners.toArray(new PanelPopupWindowListener[this.listeners.size()]);
    }

    protected void fireClosed() {
        for (PanelPopupWindowListener listener : this.listeners()) {
            listener.closed(this);
        }
    }

    protected Rectangle validateBounds(Rectangle bounds, GraphicsConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        Rectangle screen = configuration.getBounds();
        bounds = new Rectangle(bounds);
        bounds.width = Math.min(bounds.width, screen.width);
        bounds.height = Math.min(bounds.height, screen.height);
        bounds.x = Math.min(Math.max(bounds.x, screen.x), screen.x + screen.width - bounds.width);
        bounds.y = Math.min(Math.max(bounds.y, screen.y), screen.y + screen.height - bounds.height);
        return bounds;
    }
}

