/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class PopupController
implements DockControllerRepresentativeListener {
    private Map<DockElementRepresentative, ComponentObserver> listeners = new HashMap<DockElementRepresentative, ComponentObserver>();
    private DockController controller;

    public PopupController(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
        controller.addRepresentativeListener(this);
    }

    public void representativeAdded(DockController controller, DockElementRepresentative representative) {
        if (representative.getElement().asDockable() != null) {
            ComponentObserver observer = new ComponentObserver(representative);
            this.listeners.put(representative, observer);
            representative.addMouseInputListener(observer);
        }
    }

    public void representativeRemoved(DockController controller, DockElementRepresentative representative) {
        ComponentObserver observer;
        if (representative.getElement().asDockable() != null && (observer = this.listeners.remove(representative)) != null) {
            representative.removeMouseInputListener(observer);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    private static class ComponentObserver
    extends ActionPopup {
        private DockElementRepresentative representative;
        private boolean onMouseClick = false;

        public ComponentObserver(DockElementRepresentative representative) {
            super(true);
            this.representative = representative;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            if (this.isMenuOpen()) {
                return;
            }
            if (this.isEnabled() && e.getClickCount() == 1) {
                try {
                    this.onMouseClick = true;
                    this.popup(e.getComponent(), e.getX(), e.getY());
                }
                finally {
                    this.onMouseClick = false;
                }
            }
        }

        protected Point getPopupLocation(Component owner, Point location) {
            location = new Point(location);
            location = SwingUtilities.convertPoint(owner, location, this.representative.getComponent());
            if ((location = this.representative.getPopupLocation(location, !this.onMouseClick)) == null) {
                return null;
            }
            location = new Point(location);
            return SwingUtilities.convertPoint(this.representative.getComponent(), location, owner);
        }

        protected Dockable getDockable() {
            return this.representative.getElement().asDockable();
        }

        protected DockActionSource getSource() {
            return this.getDockable().getGlobalActionOffers();
        }

        protected boolean isEnabled() {
            return true;
        }
    }
}

