/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStackDockComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneTabBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class BubbleTab
extends BackgroundPanel
implements CombinedTab,
ChangeListener,
Runnable,
DockableFocusListener {
    private OrientedLabel label = new OrientedLabel();
    private BubbleColorAnimation animation;
    private boolean mouse = false;
    private boolean focused = false;
    private Dockable dockable;
    private DockController controller;
    private BubbleStackDockComponent parent;
    private int zOrder;
    private int arc = 6;
    private int borderSize;
    private int freeSpaceToSideBorder = this.borderSize = 3;
    private int freeSpaceToParallelBorder = 0;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private BubbleTabColor topMouse;
    private BubbleTabColor bottomMouse;
    private BubbleTabColor borderMouse;
    private BubbleTabColor textMouse;
    private BubbleTabColor top;
    private BubbleTabColor bottom;
    private BubbleTabColor border;
    private BubbleTabColor text;
    private BubbleTabColor topSelectedMouse;
    private BubbleTabColor bottomSelectedMouse;
    private BubbleTabColor borderSelectedMouse;
    private BubbleTabColor textSelectedMouse;
    private BubbleTabColor topSelected;
    private BubbleTabColor bottomSelected;
    private BubbleTabColor borderSelected;
    private BubbleTabColor textSelected;
    private BubbleTabColor topFocusedMouse;
    private BubbleTabColor bottomFocusedMouse;
    private BubbleTabColor borderFocusedMouse;
    private BubbleTabColor textFocusedMouse;
    private BubbleTabColor topFocused;
    private BubbleTabColor bottomFocused;
    private BubbleTabColor borderFocused;
    private BubbleTabColor textFocused;
    private BubbleTabColor[] colors;
    private BubbleTabFont fontFocused;
    private BubbleTabFont fontSelected;
    private BubbleTabFont fontUnselected;
    private Background background = new Background();
    private static final int STATE_SELECTED = 1;
    private static final int STATE_FOCUSED = 3;
    private static final int STATE_MOUSE = 4;
    private int state = 0;

    public BubbleTab(BubbleStackDockComponent parent, Dockable dockable) {
        super(false, false);
        this.dockable = dockable;
        this.parent = parent;
        this.label.setHorizontal(this.orientation.isHorizontal());
        this.label.setBackground(this.background);
        this.setBackground(this.background);
        this.animation = new BubbleColorAnimation();
        this.animation.addTask(this);
        this.topMouse = new BubbleTabColor(4, "stack.tab.background.top.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomMouse = new BubbleTabColor(4, "stack.tab.background.bottom.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderMouse = new BubbleTabColor(4, "stack.tab.border.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textMouse = new BubbleTabColor(4, "stack.tab.foreground.mouse", "text", this.animation, dockable, Color.BLACK);
        this.top = new BubbleTabColor(0, "stack.tab.background.top", "top", this.animation, dockable, Color.RED.brighter());
        this.bottom = new BubbleTabColor(0, "stack.tab.background.bottom", "bottom", this.animation, dockable, Color.RED.darker());
        this.border = new BubbleTabColor(0, "stack.tab.border", "border", this.animation, dockable, Color.RED.darker().darker());
        this.text = new BubbleTabColor(0, "stack.tab.foreground", "text", this.animation, dockable, Color.BLACK);
        this.topSelectedMouse = new BubbleTabColor(5, "stack.tab.background.top.selected.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomSelectedMouse = new BubbleTabColor(5, "stack.tab.background.bottom.selected.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderSelectedMouse = new BubbleTabColor(5, "stack.tab.border.selected.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textSelectedMouse = new BubbleTabColor(5, "stack.tab.foreground.selected.mouse", "text", this.animation, dockable, Color.BLACK);
        this.topSelected = new BubbleTabColor(1, "stack.tab.background.top.selected", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomSelected = new BubbleTabColor(1, "stack.tab.background.bottom.selected", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderSelected = new BubbleTabColor(1, "stack.tab.border.selected", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textSelected = new BubbleTabColor(1, "stack.tab.foreground.selected", "text", this.animation, dockable, Color.BLACK);
        this.topFocusedMouse = new BubbleTabColor(7, "stack.tab.background.top.focused.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomFocusedMouse = new BubbleTabColor(7, "stack.tab.background.bottom.focused.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderFocusedMouse = new BubbleTabColor(7, "stack.tab.border.focused.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textFocusedMouse = new BubbleTabColor(7, "stack.tab.foreground.focused.mouse", "text", this.animation, dockable, Color.BLACK);
        this.topFocused = new BubbleTabColor(3, "stack.tab.background.top.focused", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomFocused = new BubbleTabColor(3, "stack.tab.background.bottom.focused", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderFocused = new BubbleTabColor(3, "stack.tab.border.focused", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textFocused = new BubbleTabColor(3, "stack.tab.foreground.focused", "text", this.animation, dockable, Color.BLACK);
        this.colors = new BubbleTabColor[]{this.top, this.bottom, this.border, this.text, this.topMouse, this.bottomMouse, this.borderMouse, this.textMouse, this.topSelected, this.bottomSelected, this.borderSelected, this.textSelected, this.topSelectedMouse, this.bottomSelectedMouse, this.borderSelectedMouse, this.textSelectedMouse, this.topFocused, this.bottomFocused, this.borderFocused, this.textFocused, this.topFocusedMouse, this.bottomFocusedMouse, this.borderFocusedMouse, this.textFocusedMouse};
        this.fontFocused = new BubbleTabFont("tab.focused", dockable);
        this.fontSelected = new BubbleTabFont("tab.selected", dockable);
        this.fontUnselected = new BubbleTabFont("tab.unselected", dockable);
        this.setController(parent.getController());
        this.checkAnimation();
        this.setOpaque(false);
        this.add(this.label);
        this.setLayout(null);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                BubbleTab.this.parent.setSelectedDockable(BubbleTab.this.dockable);
            }

            public void mouseEntered(MouseEvent e) {
                BubbleTab.this.mouse = true;
                BubbleTab.this.checkAnimation();
            }

            public void mouseExited(MouseEvent e) {
                BubbleTab.this.mouse = false;
                BubbleTab.this.checkAnimation();
            }
        };
        this.addMouseListener(listener);
        this.label.addMouseListener(listener);
    }

    public TabPane getTabParent() {
        return this.parent;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    public void setTooltip(String tooltip) {
        this.setToolTipText(tooltip);
        this.label.setToolTipText(tooltip);
    }

    public void setPaneVisible(boolean visible) {
        this.parent.getTabHandler().setVisible(this, visible);
    }

    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    public void setOrientation(TabPlacement orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.label.setHorizontal(orientation.isHorizontal());
            this.revalidate();
            this.repaint();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this);
        }
        for (BubbleTabColor color : this.colors) {
            color.connect(controller);
        }
        this.fontFocused.connect(controller);
        this.fontSelected.connect(controller);
        this.fontUnselected.connect(controller);
        this.background.setController(controller);
        this.controller = controller;
        if (controller != null) {
            controller.addDockableFocusListener(this);
            this.focused = controller.getFocusedDockable() == this.dockable;
        }
        this.checkAnimation();
        this.animation.kick();
    }

    public void setZOrder(int order) {
        this.zOrder = order;
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public Insets getOverlap(TabPaneComponent other) {
        return new Insets(0, 0, 0, 0);
    }

    public void dockableFocused(DockableFocusEvent event) {
        boolean old = this.focused;
        boolean bl = this.focused = this.dockable == event.getNewFocusOwner();
        if (old != this.focused) {
            this.checkAnimation();
        }
    }

    public void run() {
        this.label.setForeground(this.animation.getColor("text"));
        this.repaint();
    }

    public Dimension getPreferredSize(Tab[] tabs) {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = this.label.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            return new Dimension(size.width + 2 * this.borderSize + 2 * this.freeSpaceToSideBorder, size.height + 2 * this.arc + this.borderSize + this.freeSpaceToParallelBorder);
        }
        return new Dimension(size.width + 2 * this.arc + this.borderSize + this.freeSpaceToParallelBorder, size.height + 2 * this.borderSize + 2 * this.freeSpaceToSideBorder);
    }

    public Dimension getMinimumSize(Tab[] tabs) {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToSideBorder, this.borderSize + this.freeSpaceToParallelBorder + this.borderSize, this.getWidth() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder, this.getHeight() - this.arc - this.borderSize - this.freeSpaceToParallelBorder);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToSideBorder, this.borderSize + this.freeSpaceToParallelBorder, this.getWidth() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder, this.getHeight() - this.arc - this.borderSize - this.freeSpaceToParallelBorder);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToParallelBorder, this.borderSize + this.freeSpaceToSideBorder, this.getWidth() - this.arc - this.borderSize - this.freeSpaceToParallelBorder, this.getHeight() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToParallelBorder + this.freeSpaceToSideBorder, this.borderSize + this.freeSpaceToSideBorder, this.getWidth() - this.arc - this.borderSize - this.freeSpaceToParallelBorder, this.getHeight() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder);
            }
        }
    }

    public void paintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bottom = this.animation.getColor("bottom");
        Color top = this.animation.getColor("top");
        Color border = this.animation.getColor("border");
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setColor(border);
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                g2.fillRoundRect(0, 0, w, h + this.arc, 2 * this.arc, 2 * this.arc);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g2.fillRoundRect(0, -this.arc, w, h + this.arc, 2 * this.arc, 2 * this.arc);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                g2.fillRoundRect(0, 0, w + this.arc, h, 2 * this.arc, 2 * this.arc);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g2.fillRoundRect(-this.arc, 0, w + this.arc, h, 2 * this.arc, 2 * this.arc);
            }
        }
        if (this.orientation.isHorizontal()) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, top, 0.0f, h - this.borderSize, bottom));
        } else {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, top, w - this.borderSize, 0.0f, bottom));
        }
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                g2.fillRoundRect(this.borderSize, this.borderSize, w - 2 * this.borderSize, h + this.arc - this.borderSize, 2 * this.arc, 2 * this.arc);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g2.fillRoundRect(this.borderSize, -this.arc, w - 2 * this.borderSize, h + this.arc - this.borderSize, 2 * this.arc, 2 * this.arc);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                g2.fillRoundRect(this.borderSize, this.borderSize, w + this.arc - this.borderSize, h - 2 * this.borderSize, 2 * this.arc, 2 * this.arc);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g2.fillRoundRect(-this.arc, this.borderSize, w + this.arc - this.borderSize, h - 2 * this.borderSize, 2 * this.arc, 2 * this.arc);
            }
        }
        g2.dispose();
    }

    public void paintForeground(Graphics g) {
        Graphics child = g.create(this.label.getX(), this.label.getY(), this.label.getWidth(), this.label.getHeight());
        this.label.paint(child);
        child.dispose();
    }

    public void paintOverlay(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.orientation.isHorizontal()) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, h / 2, Color.WHITE));
        } else {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), w / 2, 0.0f, Color.WHITE));
        }
        g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, w, h + this.arc, 2 * this.arc, 2 * this.arc));
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(0.0f, -this.arc, w, h + this.arc, 2 * this.arc, 2 * this.arc));
                break;
            }
            case LEFT_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, w + this.arc, h, 2 * this.arc, 2 * this.arc));
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(-this.arc, 0.0f, w + this.arc, h, 2 * this.arc, 2 * this.arc));
            }
        }
        if (this.orientation.isHorizontal()) {
            g2.fillRect(0, 0, w, h / 2);
        } else {
            g2.fillRect(0, 0, w / 2, h);
        }
        g2.dispose();
    }

    public void paintChildren(Graphics g) {
    }

    public JComponent getComponent() {
        return this;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return false;
    }

    public boolean shouldFocus() {
        return true;
    }

    public boolean shouldTransfersFocus() {
        return true;
    }

    public void addMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.label.addMouseListener(listener);
        this.label.addMouseMotionListener(listener);
    }

    public void removeMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
        this.label.removeMouseListener(listener);
        this.label.removeMouseMotionListener(listener);
    }

    public void stateChanged(ChangeEvent e) {
        this.checkAnimation();
    }

    private void checkAnimation() {
        this.state = 0;
        if (this.parent.getSelectedDockable() == this.dockable) {
            this.state |= 1;
        }
        if (this.mouse) {
            this.state |= 4;
        }
        if (this.focused) {
            this.state |= 3;
        }
        for (BubbleTabColor color : this.colors) {
            color.transmit();
        }
        this.updateFonts();
    }

    public void updateFonts() {
        if (this.focused) {
            this.label.setFontModifier((FontModifier)this.fontFocused.value());
        } else if (this.parent.getSelectedDockable() == this.dockable) {
            this.label.setFontModifier((FontModifier)this.fontSelected.value());
        } else {
            this.label.setFontModifier((FontModifier)this.fontUnselected.value());
        }
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void stopAnimation() {
        this.animation.stop();
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneTabBackgroundComponent {
        public Background() {
            super(TabPaneTabBackgroundComponent.KIND, "dock.background.tabPane.child.tab");
        }

        public Tab getTab() {
            return BubbleTab.this;
        }

        public TabPaneComponent getChild() {
            return BubbleTab.this;
        }

        public TabPane getPane() {
            return BubbleTab.this.getTabParent();
        }

        public Component getComponent() {
            return BubbleTab.this;
        }
    }

    protected class BubbleTabFont
    extends TabFont {
        public BubbleTabFont(String id, Dockable dockable) {
            super(id, BubbleTab.this.parent.getStation(), dockable);
        }

        protected void changed(FontModifier oldValue, FontModifier newValue) {
            BubbleTab.this.updateFonts();
        }
    }

    protected class BubbleTabColor
    extends TabColor {
        private int state;
        private String animationId;
        private BubbleColorAnimation animation;

        public BubbleTabColor(int state, String id, String animationId, BubbleColorAnimation animation, Dockable dockable, Color backup) {
            super(id, BubbleTab.this.parent.getStation(), dockable, backup);
            this.state = state;
            this.animationId = animationId;
            this.animation = animation;
        }

        public void transmit() {
            if (BubbleTab.this.getState() == this.state) {
                this.animation.putColor(this.animationId, (Color)this.value());
            }
        }

        protected void changed(Color oldColor, Color newColor) {
            if (BubbleTab.this.getState() == this.state) {
                this.animation.putColor(this.animationId, newColor);
            }
        }
    }
}

