/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.util.IconManager;
import javax.swing.Icon;

public class CloseAction
extends SimpleButtonAction
implements ListeningDockAction {
    private DockController controller;
    private Listener listener = new Listener();

    public CloseAction(DockController dockController) {
        this.setText(DockUI.getDefaultDockUI().getString("close"));
        this.setTooltip(DockUI.getDefaultDockUI().getString("close.tooltip"));
        this.setController(dockController);
    }

    public void setController(DockController dockController) {
        if (dockController != this.controller) {
            if (this.controller != null) {
                this.controller.getIcons().remove("close", this.listener);
            }
            this.controller = dockController;
            if (dockController != null) {
                IconManager iconManager = dockController.getIcons();
                iconManager.add("close", this.listener);
                this.setIcon(iconManager.getIcon("close"));
            }
        }
    }

    public void action(Dockable dockable) {
        this.close(dockable);
    }

    protected void close(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        if (dockStation != null) {
            dockStation.drag(dockable);
        }
    }

    private class Listener
    implements IconManagerListener {
        private Listener() {
        }

        public void iconChanged(String string, Icon icon) {
            CloseAction.this.setIcon(icon);
        }
    }
}

