/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationListener;
import java.util.ArrayList;
import java.util.List;

public class DockStationListenerManager {
    private List<DockStationListener> listeners = new ArrayList<DockStationListener>();
    private DockStation station;

    public DockStationListenerManager(DockStation dockStation) {
        if (dockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = dockStation;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void addListener(DockStationListener dockStationListener) {
        this.listeners.add(dockStationListener);
    }

    public void removeListener(DockStationListener dockStationListener) {
        this.listeners.remove(dockStationListener);
    }

    public void fireDockableVisibilitySet(Dockable dockable, boolean bl) {
        for (DockStationListener dockStationListener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            dockStationListener.dockableVisibiltySet(this.station, dockable, bl);
        }
    }

    public void fireDockableAdded(Dockable dockable) {
        for (DockStationListener dockStationListener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            dockStationListener.dockableAdded(this.station, dockable);
        }
    }

    public void fireDockableRemoved(Dockable dockable) {
        for (DockStationListener dockStationListener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            dockStationListener.dockableRemoved(this.station, dockable);
        }
    }

    public void fireDockableAdding(Dockable dockable) {
        for (DockStationListener dockStationListener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            dockStationListener.dockableAdding(this.station, dockable);
        }
    }

    public void fireDockableRemoving(Dockable dockable) {
        for (DockStationListener dockStationListener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            dockStationListener.dockableRemoving(this.station, dockable);
        }
    }

    public void fireDockableSelected(Dockable dockable, Dockable dockable2) {
        for (DockStationListener dockStationListener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            dockStationListener.dockableSelected(this.station, dockable, dockable2);
        }
    }
}

