/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import java.awt.Dimension;

public abstract class AbstractTab
extends AbstractTabPaneComponent
implements Tab {
    private Dockable dockable;
    private boolean bound = false;
    private DockController controller;
    private boolean selected = false;
    private boolean focused = false;
    private TabPaneListener selectionListener = new TabPaneListener(){

        public void added(TabPane tabPane, Dockable dockable) {
        }

        public void removed(TabPane tabPane, Dockable dockable) {
        }

        public void selectionChanged(TabPane tabPane) {
            boolean bl;
            boolean bl2 = bl = tabPane.getSelectedDockable() == AbstractTab.this.getDockable();
            if (bl != AbstractTab.this.selected) {
                AbstractTab.this.selected = bl;
                AbstractTab.this.informSelectionChanged(AbstractTab.this.selected);
            }
        }

        public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
        }
    };
    private DockableFocusListener focusListener = new DockableFocusListener(){

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            boolean bl;
            boolean bl2 = bl = dockableFocusEvent.getNewFocusOwner() == AbstractTab.this.getDockable();
            if (bl != AbstractTab.this.focused) {
                AbstractTab.this.focused = bl;
                AbstractTab.this.informFocusChanged(AbstractTab.this.focused);
            }
        }
    };

    public AbstractTab(TabPane tabPane, Dockable dockable) {
        super(tabPane);
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Dimension getMinimumSize(Tab[] tabArray) {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize(Tab[] tabArray) {
        return this.getPreferredSize();
    }

    public void bind() {
        if (this.bound) {
            throw new IllegalStateException("this tab is already bound");
        }
        this.bound = true;
        if (this.controller != null) {
            this.controller.addDockableFocusListener(this.focusListener);
            this.focused = this.controller.getFocusedDockable() == this.getDockable();
            this.informFocusChanged(this.focused);
        }
        TabPane tabPane = this.getTabParent();
        tabPane.addTabPaneListener(this.selectionListener);
        this.selected = tabPane.getSelectedDockable() == this.getDockable();
        this.informSelectionChanged(this.selected);
    }

    public void unbind() {
        if (!this.bound) {
            throw new IllegalStateException("this tab is not bound");
        }
        this.bound = false;
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this.focusListener);
        }
        this.getTabParent().removeTabPaneListener(this.selectionListener);
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected abstract void informSelectionChanged(boolean var1);

    public boolean isFocused() {
        return this.focused;
    }

    protected abstract void informFocusChanged(boolean var1);

    public void setController(DockController dockController) {
        if (this.bound) {
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this.focusListener);
            }
            this.controller = dockController;
            if (this.controller != null) {
                this.controller.addDockableFocusListener(this.focusListener);
                this.focused = this.controller.getFocusedDockable() == this.getDockable();
                this.informFocusChanged(this.focused);
            }
        } else {
            this.controller = dockController;
        }
    }
}

