/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.dock.security.SecureMouseFocusObserver;
import bibliothek.util.JavaVersionWorkaround;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GlassedPane
extends JPanel {
    private JComponent contentPane = new JPanel();
    private JComponent glassPane = new GlassPane();
    private SecureMouseFocusObserver focusController;

    public GlassedPane() {
        this.setLayout(null);
        this.add(this.glassPane);
        this.add(this.contentPane);
        this.setFocusCycleRoot(true);
    }

    public GlassedPane(SecureMouseFocusObserver secureMouseFocusObserver) {
        this();
        secureMouseFocusObserver.addGlassPane(this);
    }

    public void setFocusController(SecureMouseFocusObserver secureMouseFocusObserver) {
        this.focusController = secureMouseFocusObserver;
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.contentPane.setBounds(0, 0, n, n2);
        this.glassPane.setBounds(0, 0, n, n2);
    }

    public Dimension getPreferredSize() {
        return this.contentPane.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.contentPane.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.contentPane.getMinimumSize();
    }

    public void setContentPane(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("Content Pane must not be null");
        }
        this.contentPane = jComponent;
        this.removeAll();
        this.add(this.glassPane);
        this.add(jComponent);
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    private class GlassPane
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component dragged;
        private Component over;
        private int downCount = 0;

        public GlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.setOpaque(false);
            this.setFocusable(false);
            JavaVersionWorkaround.markAsGlassPane(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && this.isVisible()) {
                this.send(mouseEvent);
            }
            if (!this.isVisible()) {
                this.downCount = 0;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!mouseWheelEvent.isConsumed()) {
                this.send(mouseWheelEvent);
            }
        }

        private void send(MouseEvent mouseEvent) {
            this.send(mouseEvent, mouseEvent.getID());
        }

        private void send(MouseEvent mouseEvent, int n) {
            boolean bl;
            Point point = mouseEvent.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, point.x, point.y);
            boolean bl2 = n == 506;
            boolean bl3 = n == 501;
            boolean bl4 = n == 502;
            boolean bl5 = n == 503;
            boolean bl6 = n == 504;
            boolean bl7 = bl = n == 505;
            if (bl2 && this.dragged == null) {
                this.dragged = component;
            } else if (bl2) {
                component = this.dragged;
            }
            if (bl3) {
                ++this.downCount;
            }
            if (this.downCount > 0 && this.dragged != null) {
                component = this.dragged;
            } else if (this.downCount > 0 && this.dragged == null) {
                this.dragged = component;
            } else if (this.downCount == 0) {
                this.dragged = null;
            }
            if (bl4) {
                --this.downCount;
                if (this.downCount < 0) {
                    this.downCount = 0;
                }
            }
            if ((bl5 || bl6 || bl) && this.over != component) {
                if (this.over != null) {
                    this.over.dispatchEvent(new MouseEvent(this.over, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }
                this.over = component;
                if (this.over != null) {
                    this.over.dispatchEvent(new MouseEvent(this.over, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }
            }
            if (component == null) {
                this.setCursor(null);
                this.setToolTipText(null);
            } else {
                point = SwingUtilities.convertPoint(this, point, component);
                MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                if (GlassedPane.this.focusController != null) {
                    GlassedPane.this.focusController.check(mouseEvent2);
                }
                component.dispatchEvent(mouseEvent2);
                Cursor cursor = component.getCursor();
                if (this.getCursor() != cursor) {
                    this.setCursor(cursor);
                }
                if (component instanceof JComponent) {
                    String string;
                    JComponent jComponent = (JComponent)component;
                    String string2 = jComponent.getToolTipText(mouseEvent2);
                    if (!(string2 == (string = this.getToolTipText()) || string2 != null && string != null && string2.equals(string))) {
                        this.setToolTipText(string2);
                    }
                } else {
                    this.setToolTipText(null);
                }
            }
        }

        private void send(MouseWheelEvent mouseWheelEvent) {
            Point point = mouseWheelEvent.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, point.x, point.y);
            if (component != null) {
                point = SwingUtilities.convertPoint(this, point, component);
                MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent(component, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                if (GlassedPane.this.focusController != null) {
                    GlassedPane.this.focusController.check(mouseWheelEvent2);
                }
                component.dispatchEvent(mouseWheelEvent2);
            }
        }
    }
}

