/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.event;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;

public class DockHierarchyEvent {
    private Dockable dockable;
    private DockStation[] path;
    private DockController controller;

    public DockHierarchyEvent(Dockable dockable) {
        this(dockable, dockable.getController());
    }

    public DockHierarchyEvent(Dockable dockable, DockController dockController) {
        this.dockable = dockable;
        this.controller = dockController;
        int n = 0;
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            ++n;
            Dockable dockable2 = dockStation.asDockable();
            if (dockable2 == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable2.getDockParent();
        }
        this.path = new DockStation[n];
        dockStation = dockable.getDockParent();
        for (int i = n - 1; i >= 0; --i) {
            this.path[i] = dockStation;
            if (i <= 0) continue;
            dockStation = dockStation.asDockable().getDockParent();
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation[] getPath() {
        return this.path;
    }

    public DockController getController() {
        return this.controller;
    }
}

