/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class SmoothDefaultTitle
extends BasicDockTitle {
    private final int ACTIVE_STATE = 0;
    private final int INACTIVE_STATE = 1;
    private int current = 0;
    private SmoothChanger changer = new SmoothChanger(2){

        protected int destination() {
            if (SmoothDefaultTitle.this.isActive()) {
                return 0;
            }
            return 1;
        }

        protected void repaint(int[] nArray) {
            SmoothDefaultTitle.this.current = nArray[0];
            SmoothDefaultTitle.this.updateForegroundColor();
            SmoothDefaultTitle.this.repaint();
        }
    };

    public SmoothDefaultTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion);
    }

    public int getDuration() {
        return this.changer.getDuration();
    }

    public void setDuration(int n) {
        this.changer.setDuration(n);
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    protected void updateColors() {
        super.updateColors();
        this.updateForegroundColor();
    }

    protected void updateForegroundColor() {
        boolean bl = false;
        if (this.changer != null) {
            int n = this.getDuration();
            if (this.isActive() && this.current != n || !this.isActive() && this.current != 0) {
                double d = (double)this.current / (double)n;
                this.setForeground(Colors.between(this.getInactiveTextColor(), this.getActiveTextColor(), d));
                bl = true;
            }
            if (!bl) {
                if (this.isActive()) {
                    this.setForeground(this.getActiveTextColor());
                } else {
                    this.setForeground(this.getInactiveTextColor());
                }
            }
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        int n = this.getDuration();
        if (this.isActive() && this.current != n || !this.isActive() && this.current != 0) {
            double d = (double)this.current / (double)n;
            Color color = Colors.between(this.getInactiveLeftColor(), this.getActiveLeftColor(), d);
            Color color2 = Colors.between(this.getInactiveRightColor(), this.getActiveRightColor(), d);
            GradientPaint gradientPaint = this.getGradient(color, color2, jComponent);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        } else {
            super.paintBackground(graphics, jComponent);
        }
    }
}

