/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.AbstractTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

public class EclipseTab
extends AbstractTab
implements CombinedTab {
    private TabComponent component;
    private EclipseTabPane parent;

    public EclipseTab(EclipseTabPane eclipseTabPane, Dockable dockable, TabComponent tabComponent) {
        super(eclipseTabPane, dockable);
        this.parent = eclipseTabPane;
        this.component = tabComponent;
        this.component.setIcon(dockable.getTitleIcon());
        this.component.setText(dockable.getTitleText());
    }

    public Component getComponent() {
        return this.component.getComponent();
    }

    public TabComponent getTabComponent() {
        return this.component;
    }

    public void setPaneVisible(boolean bl) {
        this.parent.getTabHandler().setVisible(this, bl);
    }

    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    public void setZOrder(int n) {
        this.parent.getTabHandler().setZOrder(this, n);
    }

    public int getZOrder() {
        return this.parent.getTabHandler().getZOrder(this);
    }

    public void setIcon(Icon icon) {
        this.component.setIcon(icon);
    }

    public void setText(String string) {
        this.component.setText(string);
    }

    public void setTooltip(String string) {
        this.component.setTooltip(string);
    }

    public void setOrientation(TabPlacement tabPlacement) {
        super.setOrientation(tabPlacement);
        this.component.setOrientation(tabPlacement);
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.component.addMouseInputListener(mouseInputListener);
    }

    public Dimension getMinimumSize(Tab[] tabArray) {
        return this.component.getMinimumSize(this.extract(tabArray));
    }

    public Dimension getPreferredSize(Tab[] tabArray) {
        return this.component.getPreferredSize(this.extract(tabArray));
    }

    private TabComponent[] extract(Tab[] tabArray) {
        TabComponent[] tabComponentArray = new TabComponent[tabArray.length];
        for (int i = 0; i < tabArray.length; ++i) {
            if (!(tabArray[i] instanceof EclipseTab)) continue;
            tabComponentArray[i] = ((EclipseTab)tabArray[i]).getTabComponent();
        }
        return tabComponentArray;
    }

    public DockElement getElement() {
        return this.getDockable();
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.component.removeMouseInputListener(mouseInputListener);
    }

    public void bind() {
        this.component.bind();
        super.bind();
    }

    public void unbind() {
        this.component.unbind();
        super.unbind();
    }

    public Insets getOverlap(TabPaneComponent tabPaneComponent) {
        if (tabPaneComponent instanceof EclipseTab) {
            EclipseTab eclipseTab = (EclipseTab)tabPaneComponent;
            return this.getTabComponent().getOverlap(eclipseTab.getTabComponent());
        }
        return super.getOverlap(tabPaneComponent);
    }

    public void setPaintIconWhenInactive(boolean bl) {
        this.component.setPaintIconWhenInactive(bl);
    }

    protected void informFocusChanged(boolean bl) {
        this.component.setFocused(bl);
    }

    protected void informSelectionChanged(boolean bl) {
        this.component.setSelected(bl);
    }

    public String toString() {
        Dockable dockable = this.component.getElement().asDockable();
        if (dockable == null) {
            return this.getClass().getSimpleName() + "@[component=" + this.component + "]";
        }
        return this.getClass().getSimpleName() + "@[dockable title=" + dockable.getTitleText() + "]";
    }
}

