/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.util.ReverseCompoundBorder;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;

public class NoTitleDisplayer
extends JPanel
implements DockableDisplayer,
InvisibleTabPane,
BorderedComponent {
    private Dockable dockable;
    private DockController controller;
    private DockStation station;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private PropertyValue<TabPainter> painter;
    private boolean defaultBorderHint;
    private Boolean borderHint;
    private DockableDisplayerHints hints;
    private boolean bordered;
    private boolean respectHints;
    private TitleBarObserver observer;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private InvisibleTab invisibleTab;
    private Border innerBorder;
    private Border outerBorder;

    public NoTitleDisplayer(DockStation dockStation, Dockable dockable, EclipseThemeConnector.TitleBar titleBar) {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.setOpaque(false);
        this.bordered = titleBar == EclipseThemeConnector.TitleBar.NONE_BORDERED || titleBar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        this.respectHints = titleBar == EclipseThemeConnector.TitleBar.NONE_HINTED || titleBar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        this.observer = new TitleBarObserver(dockable, titleBar){

            protected void invalidated() {
                for (DockableDisplayerListener dockableDisplayerListener : NoTitleDisplayer.this.listeners()) {
                    dockableDisplayerListener.discard(NoTitleDisplayer.this);
                }
            }
        };
        if (this.respectHints) {
            this.hints = new DockableDisplayerHints(){

                public void setShowBorderHint(Boolean bl) {
                    NoTitleDisplayer.this.borderHint = bl;
                    NoTitleDisplayer.this.updateFullBorder();
                }
            };
        }
        this.setStation(dockStation);
        this.setDockable(dockable);
        this.setBorder(null);
        this.defaultBorderHint = this.bordered;
        this.painter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

            @Override
            protected void valueChanged(TabPainter tabPainter, TabPainter tabPainter2) {
                NoTitleDisplayer.this.updateFullBorder();
                NoTitleDisplayer.this.updateInvisibleTab();
            }
        };
        this.updateFullBorder();
        this.updateInvisibleTab();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    protected boolean getBorderHint() {
        if (this.borderHint != null) {
            return this.borderHint;
        }
        return this.defaultBorderHint;
    }

    public void updateFullBorder() {
        if ((this.bordered || this.respectHints) && this.painter != null) {
            TabPainter tabPainter = this.painter.getValue();
            this.outerBorder = this.controller == null || tabPainter == null || this.dockable == null ? null : (this.hints == null || this.getBorderHint() ? tabPainter.getFullBorder(this, this.controller, this.dockable) : null);
            this.updateBorder();
        }
    }

    public void setBorder(Dockable dockable, Border border) {
        if (dockable != this.dockable) {
            throw new IllegalArgumentException("unknown dockable: " + dockable);
        }
        if ((this.bordered || this.respectHints) && (this.hints == null || this.getBorderHint())) {
            this.innerBorder = border;
            this.updateBorder();
        }
    }

    private void updateBorder() {
        if (this.innerBorder == null && this.outerBorder == null) {
            this.setBorder(null);
        } else if (this.innerBorder == null) {
            this.setBorder(this.outerBorder);
        } else if (this.outerBorder == null) {
            this.setBorder(this.innerBorder);
        } else {
            this.setBorder(new ReverseCompoundBorder(this.outerBorder, this.innerBorder));
        }
    }

    protected void updateInvisibleTab() {
        TabPainter tabPainter;
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        if (this.dockable != null && this.painter != null && (tabPainter = this.painter.getValue()) != null) {
            this.invisibleTab = tabPainter.createInvisibleTab(this, this.dockable);
            this.invisibleTab.setController(this.getController());
        }
    }

    public TabPlacement getTabPlacement() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getProperties().get(StackDockStation.TAB_PLACEMENT);
    }

    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintBorder(graphics);
    }

    public Component getComponent() {
        return this;
    }

    public DockController getController() {
        return this.controller;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void addDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.add(dockableDisplayerListener);
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.remove(dockableDisplayerListener);
    }

    protected DockableDisplayerListener[] listeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    public Dockable getSelectedDockable() {
        return this.dockable;
    }

    public void setController(DockController dockController) {
        this.controller = dockController;
        if (this.painter != null) {
            this.painter.setProperties(dockController == null ? null : dockController.getProperties());
        }
        if (this.observer != null) {
            this.observer.setController(dockController);
        }
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(dockController);
        }
        this.updateFullBorder();
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.configureDisplayerHints(null);
        }
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        this.dockable = dockable;
        if (this.observer != null) {
            this.observer.setDockable(dockable);
        }
        this.removeAll();
        if (dockable != null) {
            this.add(dockable.getComponent());
            dockable.configureDisplayerHints(this.hints);
        }
        this.updateFullBorder();
        this.updateInvisibleTab();
    }

    public void setStation(DockStation dockStation) {
        this.station = dockStation;
    }

    public void setTitle(DockTitle dockTitle) {
        this.title = dockTitle;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
    }

    public boolean titleContains(int n, int n2) {
        return false;
    }
}

