% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_regions}
\alias{plot_regions}
\title{Plot polygons for spectral regions}
\usage{
plot_regions(
  spec,
  regions = default_spec_regions(),
  col = grDevices::rgb(0.7, 0.7, 0.7, 0.3),
  border = FALSE,
  add = TRUE,
  add_label = TRUE,
  cex_label = 1,
  ...
)
}
\arguments{
\item{spec}{spectra object}

\item{regions}{matrix with spectral regions in columns and only two rows named
"begin" and "end". Values are the bands where a spectral
regions begins and ends. See details for how the default regions are defined.}

\item{col}{color for regions. Single value or vector of length ncol (regions).}

\item{border}{color for region borders. Defaults to FALSE (no border).}

\item{add}{boolean. If TRUE (default) adds polygons to current plot (if a plot
exists) or throws an error if a plot does not exist.
If FALSE, a new plot is created **without** any spectra.}

\item{add_label}{boolean. Add region column names on top of the polygons?}

\item{cex_label}{label scale}

\item{...}{additional parameters passed to polygon().}
}
\value{
nothing. Called for its side effect.
}
\description{
\code{plot_regions} plots polygons for default (VIS, NIR, SWIR 1, SWIR 2) or customized regions of the spectrum.
}
\details{
Default regions:
spec_regions = cbind("VIS"   = c(begin = 400,  end = 700),
                     "NIR"   = c(begin = 800,  end = 1300),
                     "SWIR1" = c(begin = 1550, end = 1800),
                     "SWIR2" = c(begin = 2000, end = 2400)).
}
\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example, name_idx = 1)
plot_regions(spec, default_spec_regions())
plot(spec, add = TRUE)

# Alternatively, if you want to get fancy...
\dontrun{
col_fun = colorRampPalette(c(rgb(1, 1, 0, 0.7),rgb(1, 0, 0, 0.7)), alpha = TRUE)
colors = col_fun(4)

plot_regions(spec,default_spec_regions(), col = colors)
plot(spec, add = TRUE)
}
}
\author{
Jose Eduardo Meireles
}
