% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectra.R
\name{spectra}
\alias{spectra}
\title{Spectra object constructor}
\usage{
spectra(value, bands, names, meta = NULL, ...)
}
\arguments{
\item{value}{N by M numeric matrix. N samples in rows and M bands
in columns}

\item{bands}{band names in vector of length M}

\item{names}{sample names in vector of length N}

\item{meta}{spectra metadata. defaults to NULL. Must be either of length or nrow
equals to the number of samples (nrow(value) or length(names))}

\item{...}{additional arguments to metadata creation. not implemented yet}
}
\value{
spectra object
}
\description{
\code{spectra} "manually" creates a spectra object
}
\note{
This function resorts to an ugly hack to deal with metadata assignment.
      Need to think a little harder to find a solution.
}
\examples{
library(spectrolab)
# 1. Create a value matrix.
#    In this case, by removing the first column that holds the species name
rf = spec_matrix_example[ , -1]

# (2) Create a vector with band labels that match
#     the value matrix columns.
wl = colnames(rf)

# (3) Create a vector with sample labels that match
#     the value matrix rows.
#     In this case, use the first colum of spec_matrix_example
sn = spec_matrix_example[ , 1]

# Finally, construct the spectra object using the `spectra` constructor
spec = spectra(value = rf, bands = wl, names = sn)
}
\author{
Jose Eduardo Meireles
}
