% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectSpectraInTimeComp.R
\docType{class}
\name{SpectraInTimeComp-class}
\alias{SpectraInTimeComp-class}
\alias{SpectraInTimeComp}
\alias{spectraInTimeComp}
\alias{spectraintimecomp}
\alias{getDimensionReduction,SpectraInTimeComp-method}
\title{SpectraInTimeComp-class (time resolved spectra )}
\usage{
\S4method{getDimensionReduction}{SpectraInTimeComp}(object, type = NULL)
}
\arguments{
\item{object}{of class SpectraInTimeComp-class}

\item{type}{type of regression method specified, if NULL the entire slot is returned as a list}
}
\description{
Spectral-time data for 1 experiment with dimension reduction techique NMF and/or PCA decomposition included
}
\section{Slots}{

\describe{
\item{\code{dimensionReduction}}{list containing dimension reduction techique, either PCA or NMF, but only one per kind.}
}}

\examples{

\donttest{

  #  generate example 
 exampleSpectra     <-  getSpectraInTimeCompExample()

  # methods
     PCAResult      <-  getDimensionReduction( exampleSpectra, type = "PCA" )
     NMFResult      <-  getDimensionReduction( exampleSpectra, type = "NMF" )
     
     dimensionReductions  <-  getDimensionReduction( exampleSpectra )
     str(dimensionReductions  )

  # subsetting works by reducing to \code{\link{SpectraInTime-class}}
  subsetting     <-  exampleSpectra[1:3 , r(400, 450)]
  # preprocessing methods also reduce the object to \code{\link{SpectraInTime-class}}

}

}
\author{
Adriaan Blommaert
}
