% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeakFilling.R
\name{PeakFilling}
\alias{PeakFilling}
\title{Peak filling of any missed peaks}
\usage{
PeakFilling(
  Y.grouped,
  Y.spec,
  max.index.shift = 10,
  window.width = "small",
  nCPU = -1,
  FilMethod = "new"
)
}
\arguments{
\item{Y.grouped}{Peaks groups (output from the 'PeakGrouper' function).}

\item{Y.spec}{The raw NMR spectra in matrix format.}

\item{max.index.shift}{Maximal shift in index between a filled peak and the group it belongs to.}

\item{window.width}{The width of the detection window for the wavelets. Because of the Fourier transform lengths of 512 ( window.width = 'small') of 1024 ( window.width = 'large') are preferable.}

\item{nCPU}{The amount of cpu's to be used for peak detection. If set to '-1' all available cores minus 1 will be used.}

\item{FilMethod}{A more robust method for peak filling has been implemented. This is now the default. The former method can be used by specifying FilMethod == "old" however this will be deprecated.}
}
\value{
Returns a data frame with grouped peaks and possibly extra peaks obtained from the raw data (these peaks have SNR = NA).
}
\description{
This functions detects which samples (after grouping) are missing from every peak group and reanalyses the raw data to verify whether this peak is actually non-existent for this sample
}
\examples{
subset <- GetWinedata.subset()
# to reduce the example time we only select spectra 1 & 2
subset.spectra = as.matrix(subset$Spectra)[1:2,] 
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm,
                              nCPU = 1) # nCPU set to 1 for the vignette build

test.grouped <- PeakGrouper(Y.peaks = test.peaks)

test.filled <- PeakFilling(Y.grouped = test.grouped, 
                           Y.spec = subset.spectra,  
                           nCPU = 1) # nCPU set to 1 for the vignette build


}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
