% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Methods_For_Class.R
\name{showload}
\alias{showload}
\title{Shows the sparse loadings}
\usage{
showload(smpc, cols, perc = TRUE, digits = 3, variablesnames = FALSE,
  thresh = 0.001, rtn = FALSE)
}
\arguments{
\item{smpc}{A list of spca objects, typically from spcabe and spcabb.  It
can also be a simple matrix of loadings.}

\item{cols}{A vector containg the indices of the loadings to be shown.  Can
be a single value. if missing all loadings are shown: If an integer is
passed, only that dimension will be returned.}

\item{perc}{Logical: should the loodings be standardised to unit \eqn{L_1}
norm (and printed as percentage contributions).}

\item{digits}{Number of decimal digits to show.}

\item{variablesnames}{Hybrid: if not FALSE, need to pass a vector of varaiable names.}

\item{thresh}{Loadings with absolute value below this are considered zero.}

\item{rtn}{Logical: should the text table of loadings and the matrix of
summaries be returneded?}
}
\value{
If rtn = TRUE, it returns a list with the loadings.
}
\description{
Shows the non-zero loadings separately for each component.
}
\details{
Useful for large matrices to see the loadings at the same
time or to assign long descriptive names.

variablesnames must have the names of the p variables in the first p
positions.
}
\seealso{
\link{print.spca}, \link{plot.spca}. Examples in
\code{\link{spcabe}}
}

