\name{vcov.mppm}
\alias{vcov.mppm}
\title{Calculate Variance-Covariance Matrix for Fitted Multiple Point
  Process Model}
\description{
  Given a fitted multiple point process model, calculate the
  variance-covariance matrix of the parameter estimates.
}
\usage{
   \method{vcov}{mppm}(object, ..., what="vcov", err="fatal")
}
\arguments{
  \item{object}{
    A multiple point process model (object of class \code{"mppm"}).
  }
  \item{\dots}{
    Ignored.
  }
  \item{what}{
    Character string indicating which quantity should be calculated.
    Either \code{"vcov"} for the variance-covariance matrix,
    \code{"corr"} for the correlation matrix, or \code{"fisher"}
    for the Fisher information matrix.
  }
  \item{err}{
    Character string indicating what action to take if an error occurs.
    Either \code{"fatal"}, \code{"warn"} or \code{"null"}.
  }
}
\details{
  This is a method for the generic function \code{\link{vcov}}.
  
  The argument \code{object} should be a fitted multiple point process
  model (object of class \code{"mppm"}) generated by \code{\link{mppm}}.
  The model must be a Poisson point process.
  
  The variance-covariance matrix of the parameter estimates
  is computed using asymptotic theory for maximum likelihood.
  
  If \code{what="vcov"} (the default), the variance-covariance matrix
  is returned. 
  If \code{what="corr"}, the variance-covariance matrix is normalised
  to yield a correlation matrix, and this is returned.
  If \code{what="fisher"}, the Fisher information matrix is returned instead.

  In all three cases, the rows and columns of the matrix correspond
  to the parameters (coefficients) in the same order as in
  \code{coef{model}}.

  These calculations are not available if the model is not Poisson,
  or if it was computed using \code{gam}. In such cases, the
  argument \code{err} determines what will happen. If
  \code{err="fatal"} an error will occur. If \code{err="warn"}
  a warning will be issued and \code{NA} will be returned.
  If \code{err="null"}, no warning is issued, but \code{NULL} is returned.
}
\value{
  A numeric matrix (or \code{NA} or \code{NULL}).
}
\seealso{
  \code{\link{vcov}},
  \code{\link{mppm}}
}
\examples{
   data(waterstriders)
   fit <- mppm(Wat ~x, data=hyperframe(Wat=waterstriders))
   vcov(fit)
}
\keyword{spatial}
\keyword{methods}
\keyword{models}
