% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_polys.R
\name{group_polys}
\alias{group_polys}
\title{Group Polygons}
\usage{
group_polys(
  DT = NULL,
  area = NULL,
  hrType = NULL,
  hrParams = NULL,
  projection = NULL,
  id = NULL,
  coords = NULL,
  splitBy = NULL,
  spPolys = NULL
)
}
\arguments{
\item{DT}{input data.table}

\item{area}{boolean indicating either overlap group (when \code{FALSE}) or
area and proportion of overlap (when \code{TRUE})}

\item{hrType}{type of HR estimation, either 'mcp' or 'kernel'}

\item{hrParams}{a named list of parameters for \code{adehabitatHR} functions}

\item{projection}{character string defining the projection to be passed to
\code{sp::CRS}. For example, for UTM zone 36S (EPSG 32736),
the projection argument is 'EPSG:32736'. See details.}

\item{id}{Character string of ID column name}

\item{coords}{Character vector of X coordinate and Y coordinate column names}

\item{splitBy}{(optional) character string or vector of grouping column
name(s) upon which the grouping will be calculated}

\item{spPolys}{Alternatively, provide solely a SpatialPolygons object}
}
\value{
When \code{area} is \code{FALSE}, \code{group_polys} returns the
input \code{DT} appended with a \code{group} column. As with the other
grouping functions,  the actual value of \code{group} is arbitrary and
represents the identity of a given group where 1 or more individuals are
assigned to a group. If the data was reordered, the \code{group} may
change, but the contents of each group would not. When \code{area} is
\code{TRUE}, \code{group_polys} returns a proportional area overlap
\code{data.table}. In this case, ID refers to the focal individual of which
the total area is compared against the overlapping area of ID2.

If \code{area} is \code{FALSE}, a message is returned when a column named
\code{group} already exists in the input \code{DT}, because it will be
overwritten.
}
\description{
\code{group_polys} groups rows into spatial groups by overlapping polygons
(home ranges). The function accepts a \code{data.table} with relocation data,
individual identifiers and an \code{area} argument.  The relocation data is
transformed into home range \code{SpatialPolygons}. If the \code{area}
argument is \code{FALSE}, \code{group_polys} returns grouping calculated by
overlap. If the \code{area} argument is \code{TRUE}, the area and proportion
of overlap is calculated. Relocation data should be in two columns
representing the X and Y coordinates.
}
\details{
The \code{DT} must be a \code{data.table}. If your data is a
\code{data.frame}, you can convert it by reference using
\code{\link[data.table:setDT]{data.table::setDT}}.

The \code{id}, \code{coords} (and optional \code{splitBy}) arguments expect
the names of respective columns in \code{DT} which correspond to the
individual identifier, X and Y coordinates, and additional grouping columns.

The \code{projection} argument expects a character string defining the EPSG
code. For example, for UTM zone 36N (EPSG 32736), the projection argument is
'EPSG:32736'. See \url{https://spatialreference.org} for a list of EPSG
codes. Please note, R spatial has followed updates to GDAL and PROJ for
handling projections, see more at
\url{https://www.r-spatial.org/r/2020/03/17/wkt.html}. It is likely
that \code{build_polys} will return "Warning in proj4string(xy) :
CRS object has comment, which is lost in output" due to these changes.

The \code{hrType} must be either one of "kernel" or "mcp". The
\code{hrParams} must be a named list of arguments matching those of
\code{adehabitatHR::kernelUD} or \code{adehabitatHR::mcp}.

The \code{splitBy} argument offers further control over grouping. If within
your \code{DT}, you have multiple populations, subgroups or other distinct
parts, you can provide the name of the column which identifies them to
\code{splitBy}. The grouping performed by \code{group_polys} will only
consider rows within each \code{splitBy} subgroup.
}
\examples{
# Load data.table
library(data.table)

# Read example data
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))

# Cast the character column to POSIXct
DT[, datetime := as.POSIXct(datetime, tz = 'UTC')]

# EPSG code for example data
utm <- 'EPSG:32736'

group_polys(DT, area = FALSE, hrType = 'mcp',
            hrParams = list(percent = 95), projection = utm,
            id = 'ID', coords = c('X', 'Y'))

areaDT <- group_polys(DT, area = TRUE, hrType = 'mcp',
                      hrParams = list(percent = 95), projection = utm,
                      id = 'ID', coords = c('X', 'Y'))
}
\seealso{
\code{\link{build_polys}} \code{\link{group_times}}

Other Spatial grouping: 
\code{\link{group_lines}()},
\code{\link{group_pts}()}
}
\concept{Spatial grouping}
