% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_widget.R
\name{widget_polygon}
\alias{widget_polygon}
\title{Widget Polygon}
\usage{
widget_polygon(data, stroke_colour = NULL, stroke_opacity = NULL,
  stroke_width = NULL, fill_colour = NULL, fill_opacity = NULL,
  legend = TRUE, json_legend = TRUE)
}
\arguments{
\item{data}{\code{sf} object}

\item{stroke_colour}{string specifying column of \code{sf} to use for the stroke colour,
or a single value to apply to all rows of data}

\item{stroke_opacity}{string specifying column of \code{sf} to use for the stroke opacity,
or a single value to apply to all rows of data}

\item{stroke_width}{string specifying column of \code{sf} to use for the stroke width,
or a single value to apply to all rows of data}

\item{fill_colour}{string specifying column of \code{sf} to use for the fill colour,
or a single value to apply to all rows of data}

\item{fill_opacity}{string specifying column of \code{sf} to use for the fill opacity,
or a single value to apply to all rows of data}

\item{legend}{logical indicating if legend data will be returned}

\item{json_legend}{logical indicating if the legend will be returned as json}
}
\description{
Converts an `sf` object with POLYGON geometries into JSON for plotting in an htmlwidget
}
\examples{

l <- widget_polygon( widget_melbourne, legend = FALSE )
l <- widget_polygon( widget_melbourne, fill_colour = "AREASQKM16", legend = TRUE )

}
