% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haversine.R
\name{haversine}
\alias{haversine}
\title{Haversine great circle distance}
\usage{
haversine(lat_from, lon_from, lat_to, lon_to, r = 6378137)
}
\arguments{
\item{lat_from}{Latitude of the starting point.}

\item{lon_from}{Longitude of the starting point.}

\item{lat_to}{Latitude of the destination point.}

\item{lon_to}{Longitude of the destination point.}

\item{r}{Radius of the Earth in meters (default = 6378137).}
}
\value{
Vector of distances in the same unit as \code{r} (default in meters).
}
\description{
Calculates the shortest distance between two points on the
Earth's surface using the Haversine formula, also known as the great-circle
distance or "as the crow flies".
}
\details{
The Haversine ('half-versed-sine') formula was published by R.W.
Sinnott in 1984, although it has been known for much longer.
}
\examples{
haversine(53.24007, 6.520386, 53.24054, 6.520386)

}
\references{
Sinnott, R.W, 1984. Virtues of the Haversine. Sky and Telescope
68(2): 159.
}
\author{
Martin Haringa
}
