% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convK.R
\name{convKernel}
\alias{convKernel}
\title{Function for creating convolution kernel for different filters}
\usage{
convKernel(sigma = 1.4, k = c("gaussian", "LoG", "sharpen", "laplacian",
  "emboss", "sobel"))
}
\arguments{
\item{sigma}{The \code{numeric} value of standard deviation for the Gaussian or LoG filter}

\item{k}{\code{character} value: \itemize{
\item \code{gaussian} for Gaussian kernel
\item \code{LoG} for Laplacian of Gaussian kernel
\item \code{sharpen} for 3x3 convolution matrix for sharpening edges
\item \code{laplacian} for a 3x3 convolution matrix that enhances the edges
\item \code{emboss} for a 3x3 kernel that draws edges as embossed image
\item \code{sobel} gives one of the two 3x3 matrices needed to apply the Sobel filter
}}
}
\value{
An object of class \code{convKern} with the \code{matrix} of convolution kernel whose size varies according the value of \code{sigma} (in case of
\code{gaussian} or \code{LoG} option selected), and \code{k} being the convolution kernel type label
}
\description{
This function creates the convolution kernel for applying a filter to an array/matrix
}
\details{
The convolution kernel is a matrix that is used by \code{spacialfil} function over a matrix, or array, for filtering
the data. \emph{Gaussian}  kernel is calculated starting from the 2 dimension, isotropic, Gaussian distribution:
\deqn{G(x)=\frac{1}{2\pi\sigma^{2}}e^{-\frac{x^{2}+y^{2}}{2\sigma^{2}}}} \emph{Laplacian of Gaussian} kernel applies
a second derivative to enhance regions of rapid intensity changes:
\deqn{LoG\left ( x,y \right )=\frac{-1}{\pi\sigma^{4}}\left ( 1-\frac{x^{2}+y^{2}}{2\sigma^{2}}\right ) e^{-\frac{x^{2}+y^{2}}{2\sigma^{2}}}} the use of the underlying Gaussian kernel (so the name
Laplacian of Gaussian or \emph{LoG}) is needed to reduce the effect of high frequency noise that can affect the signal
distribution. \emph{Laplacian} is a \emph{Sharpen} enhance the detail. \emph{Emboss} kernel is a 3x3 convolution kernel that embosses the edges.
(but also the noise) in original dataset. \emph{Sobel} convolution kernel returns the possibility to detect edges in a more sofisticated
way, the \code{convKernel} function returns only one of the two matrices needed to apply the filter. The second one is calculated
by transposing the returned matrix in the other needed one.
}
\examples{
## Not run:
# creates a convolution kernel with Gaussian function and sigma = 1.4
K <- convKernel(sigma = 1.4, k = 'gaussian')
plot(K)
## End(**Not run**)
}
\references{
\itemize{
\item \code{gaussian} kernel  \url{http://homepages.inf.ed.ac.uk/rbf/HIPR2/gsmooth.htm}
\item \code{LoG} kernel: \url{http://homepages.inf.ed.ac.uk/rbf/HIPR2/log.htm}
\item \code{sharpen} kernel: \url{https://en.wikipedia.org/wiki/Kernel_(image_processing)}
\item \code{laplacian} kernel: \url{https://en.wikipedia.org/wiki/Discrete_Laplace_operator}
\item \code{emboss} kernel: \url{http://coding-experiments.blogspot.it/2010/07/convolution.html}
\item \code{sobel} kernel: \url{https://en.wikipedia.org/wiki/Sobel_operator}
}
}

