% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_pair_correlation.R
\name{bi_pair_correlation}
\alias{bi_pair_correlation}
\title{Bivariate Pair Correlation Function}
\usage{
bi_pair_correlation(
  mif,
  mnames,
  r_range = NULL,
  num_permutations = 100,
  edge_correction = "translation",
  keep_permutation_distribution = FALSE,
  workers = 1,
  overwrite = FALSE,
  xloc = NULL,
  yloc = NULL,
  ...
)
}
\arguments{
\item{mif}{object of class `mif`}

\item{mnames}{character vector or dataframe with 2 columns containing markers/marker combinations to run}

\item{r_range}{numeric vector radii to measure}

\item{num_permutations}{integer for the number of permutations to run}

\item{edge_correction}{character string for which edge correction to implement for Ripley's K}

\item{keep_permutation_distribution}{boolean whether to summarise the permutations or keep all}

\item{workers}{integer for number of cores to use when calculating}

\item{overwrite}{boolean for whether to overwrite existing bivariate pair correlation results}

\item{xloc}{x location column in spatial files}

\item{yloc}{y location column in spatial files}

\item{...}{other variables to pass to `[spatstat.explore::pcfcross]`}
}
\value{
`mif` object with the bivariate_pair_correlation slot filled
}
\description{
Bivariate Pair Correlation Function
}
