% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_data.R
\name{transform_data}
\alias{transform_data}
\title{transform_data: Transformation of spatial transcriptomics data}
\usage{
transform_data(
  x = NULL,
  method = "log",
  scale_f = 10000,
  sct_n_regr_genes = 3000,
  sct_min_cells = 5,
  cores = NULL
)
}
\arguments{
\item{x}{an STlist with raw count matrices.}

\item{method}{one of \code{log} or \code{sct}. If \code{log}, log-normalization is performed.
If \code{sct}, then the SCTransform method is applied by calling \code{sctransform::vst}}

\item{scale_f}{the scale factor used in logarithmic transformation}

\item{sct_n_regr_genes}{the number of genes to be used in the regression model
during SCTransform. The function \code{sctransform::vst} makes a random gene selection
based on this number}

\item{sct_min_cells}{The minimum number of spots/cells to be used in the regression
model fit by \code{sctransform::vst}}

\item{cores}{integer indicating the number of cores to use during parallelization.
If NULL, the function uses half of the available cores at a maximum. The parallelization
uses \code{parallel::mclapply} and works only in Unix systems.}
}
\value{
x an updated STlist with transformed counts.
}
\description{
Applies data transformation methods to spatial transcriptomics
samples within an STlist
}
\details{
This function takes an STlist with raw counts and performs data transformation.
The user has the option to select between log transformation after library size
normalization (\code{method='log'}), or SCTransform (\code{method='sct'}). In the case of
logarithmic transformation, a scaling factor (10^4 by default) is applied. The
function uses parallelization using "forking" (not available in Windows OS).
Note that the method \code{sct} returns a matrix with less genes as filtering is
done for low expression genes.
}
\examples{
\donttest{
# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
unzip(zipfile=zip_tmp, exdir=thrane_tmp)
# Generate the file paths to be passed to the STlist function
count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='counts')
coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='mapping')
clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                        full.names=TRUE, pattern='clinical')
# Create STlist
library('spatialGE')
melanoma <- STlist(rnacounts=count_files[c(1,2)],
                   spotcoords=coord_files[c(1,2)],
                   samples=clin_file) # Only first two samples
melanoma <- transform_data(melanoma, method='log', cores=2)
}

}
