% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified.random.R
\name{stratified.random}
\alias{stratified.random}
\title{Stratified random sample}
\usage{
stratified.random(x, strata, n = 10, reps = 1, replace = FALSE)
}
\arguments{
\item{x}{An sf class object}

\item{strata}{Column in x with stratification factor}

\item{n}{Number of random samples}

\item{reps}{Number of replicates per strata}

\item{replace}{(TRUE/FALSE) Sampling with replacement}
}
\value{
An sf class object containing random samples
}
\description{
Creates a stratified random sample of an sp class object
}
\note{
If replace=FALSE features are removed from consideration in subsequent replicates.
Conversely, if replace=TRUE, a feature can be selected multiple times across 
replicates. Not applicable if rep=1.

Depends: sf
}
\examples{
library(sf)
 if(require(sp, quietly = TRUE)) {
  data(meuse, package = "sp")
  meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                    agr = "constant")

# Create stratified variable using quartile breaks
x1 <- cut(meuse$cadmium, summary(meuse$cadmium)[-4], 
          include.lowest=TRUE)
  levels(x1) <- seq(1,nlevels(x1),1)
x2 <- cut(meuse$lead, summary(meuse$lead)[-4], 
          include.lowest=TRUE)
  levels(x2) <- seq(1,nlevels(x2),1) 
meuse$STRAT <- paste(x1, x2, sep='.')

# Counts for each full strata (note; 2 strata have only 1 observation)
tapply(meuse$STRAT, meuse$STRAT, length)
   
# 2 replicates, 2 samples with replacement
ssample <- stratified.random(meuse, strata='STRAT', n=2, reps=2, 
                             replace=TRUE)
  tapply(ssample$STRAT, ssample$STRAT, length)

# 2 replicates, 2 samples no replacement
ssample.nr <- stratified.random(meuse, strata='STRAT', n=2, reps=2)
  tapply(ssample.nr$STRAT, ssample.nr$STRAT, length)

# n=1 and reps=10 for sequential numbering of samples 
ssample.ct <- stratified.random(meuse, strata='STRAT', n=1, reps=10, 
                                replace=TRUE)
  tapply(ssample.ct$STRAT, ssample.ct$STRAT, length)

# Plot random samples colored by replacement
ssample$REP <- factor(ssample$REP)
  plot(ssample['REP'], pch=20)
} 
}
\references{
Hudak, A.T., N.L. Crookston, J.S. Evans, M.J. Falkowski, A.M.S. Smith, P. Gessler 
  and P. Morgan. (2006) Regression modelling and mapping of coniferous forest basal 
  area and tree density from discrete-return lidar and multispectral satellite data. 
  Canadian Journal of Remote Sensing 32: 126-138.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
