% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.moments.R
\name{raster.moments}
\alias{raster.moments}
\title{Raster moments}
\usage{
raster.moments(x, type = "mean", s = 3, p = 0.75)
}
\arguments{
\item{x}{raster object}

\item{type}{The global statistic to represent the local deviation
options are: "min", "min", "mean", "median", "var, "sd", 
"mad", "kurt", "skew", "quantile"}

\item{s}{Size of matrix (focal window), can be single value or two 
values defining the [x,y] dimensions of the focal matrix}

\item{p}{if type="quantile", the returned percentile.}
}
\value{
raster class object of the local distributional moment
}
\description{
Calculates focal statistical moments of a raster
}
\note{
This is a simple wrapper for the focal function, returning local 
 statistical moments
}
\examples{
\donttest{
  library(raster)
  r <- raster(nrows=100, ncols=100, xmn=571823, xmx=616763, 
              ymn=4423540, ymx=4453690)
  proj4string(r) <- crs("+proj=utm +zone=12 +datum=NAD83 +units=m +no_defs")
  r[] <- runif(ncell(r), 1000, 2500)
  r <- focal(r, focalWeight(r, 150, "Gauss") )

# Calculate 10th percentile for 3x3 window
r.p10 <- raster.moments(r, type="quantile", p=0.10) 
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
