% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearing.distance.R
\name{bearing.distance}
\alias{bearing.distance}
\title{Bearing and Distance}
\usage{
bearing.distance(x, y, distance, azimuth, EastOfNorth = TRUE)
}
\arguments{
\item{x}{x coordinate}

\item{y}{y coordinate}

\item{distance}{Distance to new point (in same units as x,y)}

\item{azimuth}{Azimuth to new point}

\item{EastOfNorth}{Specified surveying convention}
}
\description{
Calculates a new point [X,Y] based on defined bearing and distance

}
\note{
East of north is a surveying convention and defaults to true. 

}
\examples{
 pt <- cbind( x=480933, y=4479433)
 bearing.distance(pt[1], pt[2], 1000, 40)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> 

}

