% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/moments.R
\name{moments}
\alias{moments}
\title{moments}
\usage{
moments(x, plot = FALSE)
}
\arguments{
\item{x}{numeric vector}

\item{plot}{plot of distribution (TRUE/FALSE)}
}
\value{
A vector with the following values

min Minimum

25th  25th percentile

mean  Arithmetic mean

gmean  Geometric mean

hmean  Harmonic mean

median  50th percentile

7th5  75th percentile

max  Maximum

stdv  Standard deviation

var  Variance

cv  Coefficient of variation (percent)

mad  Median absolute deviation

skew  Skewness

kurt  Kurtosis

nmodes  Number of modes

mode  Mode (dominate)
}
\description{
Calculate statistical moments of a distribution
}
\examples{
x <- runif(1000,0,100)
    ( d <- moments(x, plot=TRUE) )
    ( mode.x <- moments(x, plot=FALSE)[16] )
}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}

