% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm.R
\name{bm}
\alias{bm}
\title{Brownian motion spatPomp simulator}
\usage{
bm(U = 5, N = 100, delta_t = 0.1)
}
\arguments{
\item{U}{A length-one numeric signifying dimension of the process.}

\item{N}{A length-one numeric signifying the number of observation time steps to evolve the process.}

\item{delta_t}{Process simulations are performed every \code{delta_t} time units
whereas observations occur every one time unit}
}
\value{
An object of class \sQuote{spatPomp} representing a simulation from a \code{U}-dimensional
Brownian motion
}
\description{
Generate a class \sQuote{spatPomp} object representing a \code{U}-dimensional
Brownian motion with spatial correlation decaying geometrically with
distance around a circle. The model is defined in continuous time
though in this case an Euler approximation is exact at the evaluation
times.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
b <- bm(U=4, N=20)
# See all the model specifications of the object
spy(b)
# Examples of methodologies applied to this model
# are provided in the tests directory
}
}
\seealso{
Other spatPomp examples: 
\code{\link{he10}()},
\code{\link{lorenz}()},
\code{\link{measles}()}
}
\author{
Edward L. Ionides
}
\concept{spatPomp examples}
