% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-generics.R, R/s3-sparsebnFit.R
\docType{class}
\name{sparsebnFit}
\alias{as.sparsebnFit}
\alias{is.sparsebnFit}
\alias{print.sparsebnFit}
\alias{sparsebnFit}
\title{sparsebnFit class}
\usage{
sparsebnFit(x)

as.sparsebnFit(x)

is.sparsebnFit(x)

\method{print}{sparsebnFit}(x, maxsize = 20, ...)
}
\arguments{
\item{x}{Only used internally.}

\item{maxsize}{If the number of nodes in a graph is \eqn{\le} \code{maxsize}, then the entire
graph is printed to screen, otherwise a short summary is displayed instead.}

\item{...}{(optional) additional arguments.}
}
\description{
Main class for representing DAG estimates: Represents a single DAG estimate in the solution path.
}
\details{
Generally speaking, these estimates should be wrapped up in a \code{\link{sparsebnPath}} object, but
can be handled separately if desired (be careful!).
}
\section{Slots}{

\describe{
\item{\code{edges}}{(\code{\link{edgeList}}) Edge list of estimated DAG (see \code{\link{edgeList}}).}
\item{\code{lambda}}{(\code{\link{numeric}}) Value of lambda for this estimate.}
\item{\code{nedge}}{(\code{\link{integer}}) Number of edges in this estimate.}
\item{\code{pp}}{(\code{\link{integer}}) Number of nodes.}
\item{\code{nn}}{(\code{\link{integer}}) Number of observations this estimate was based on.}
\item{\code{time}}{(\code{\link{numeric}}) Time in seconds to generate this estimate.}
}
}

\section{Methods}{

\code{\link{get.adjacency.matrix}}
\code{\link{num.nodes}}, \code{\link{num.edges}}, \code{\link{num.samples}}
}

