/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.AnyValManifest;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.util.matching.Regex;
import sparklyr.Collectors;
import sparklyr.Numeric;
import sparklyr.StructTypeAsJSON;
import sparklyr.StructTypeAsJSON$;

public final class Collectors$ {
    public static final Collectors$ MODULE$;
    private final Regex ReDecimalType;
    private final Regex ReVectorType;
    private final Regex ReBooleanArrayType;
    private final Regex ReByteArrayType;
    private final Regex ReShortArrayType;
    private final Regex ReIntegerArrayType;
    private final Regex ReLongArrayType;
    private final Regex ReDecimalArrayType;
    private final Regex ReFloatArrayType;
    private final Regex ReDoubleArrayType;
    private final Regex ReStringArrayType;
    private final Regex ReTimestampArrayType;
    private final Regex ReDateArrayType;
    private final Function2<Row, Object, String> collectForceString;
    private final Function2<Row, Object, String> collectString;

    static {
        new Collectors$();
    }

    public Regex ReDecimalType() {
        return this.ReDecimalType;
    }

    public Regex ReVectorType() {
        return this.ReVectorType;
    }

    public Regex ReBooleanArrayType() {
        return this.ReBooleanArrayType;
    }

    public Regex ReByteArrayType() {
        return this.ReByteArrayType;
    }

    public Regex ReShortArrayType() {
        return this.ReShortArrayType;
    }

    public Regex ReIntegerArrayType() {
        return this.ReIntegerArrayType;
    }

    public Regex ReLongArrayType() {
        return this.ReLongArrayType;
    }

    public Regex ReDecimalArrayType() {
        return this.ReDecimalArrayType;
    }

    public Regex ReFloatArrayType() {
        return this.ReFloatArrayType;
    }

    public Regex ReDoubleArrayType() {
        return this.ReDoubleArrayType;
    }

    public Regex ReStringArrayType() {
        return this.ReStringArrayType;
    }

    public Regex ReTimestampArrayType() {
        return this.ReTimestampArrayType;
    }

    public Regex ReDateArrayType() {
        return this.ReDateArrayType;
    }

    public int collectBoolean(Row row, int idx) {
        return this.sparklyr$Collectors$$extractBoolean(row.apply(idx));
    }

    public int[] collectBooleanArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)arr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractBoolean(x);
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public int sparklyr$Collectors$$extractBoolean(Object x) {
        int n;
        if (x instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)x);
            Predef$ predef$ = Predef$.MODULE$;
            n = new RichBoolean(bl).compare((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    public <T> int collectIntegralType(Row row, int idx, Integral<T> evidence$1, ClassTag<T> t) {
        return this.sparklyr$Collectors$$extractIntegralType(row.apply(idx), evidence$1, t);
    }

    public <T> int[] collectIntegralTypeArr(Row row, int idx, Integral<T> evidence$2, ClassTag<T> t) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)arr.map((Function1)new Serializable(evidence$2, t){
            public static final long serialVersionUID = 0L;
            private final Integral evidence$2$1;
            private final ClassTag t$1;

            public final int apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractIntegralType(x, this.evidence$2$1, this.t$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.t$1 = t$1;
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public <T> int sparklyr$Collectors$$extractIntegralType(Object x, Integral<T> evidence$3, ClassTag<T> t) {
        int n;
        Option option = t.unapply(x);
        if (!option.isEmpty() && option.get() instanceof Object) {
            Predef$ predef$ = Predef$.MODULE$;
            n = ((scala.math.Numeric)evidence$3).toInt(x);
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    public <T> Numeric collectNumericType(Row row, int idx, scala.math.Numeric<T> evidence$4, ClassTag<T> t) {
        return this.sparklyr$Collectors$$extractNumericType(row.apply(idx), evidence$4, t);
    }

    public <T> Numeric[] collectNumericTypeArr(Row row, int idx, scala.math.Numeric<T> evidence$5, ClassTag<T> t) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Numeric[])((WrappedArray)arr.map((Function1)new Serializable(evidence$5, t){
            public static final long serialVersionUID = 0L;
            private final scala.math.Numeric evidence$5$1;
            private final ClassTag t$2;

            public final Numeric apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractNumericType(x, this.evidence$5$1, this.t$2);
            }
            {
                this.evidence$5$1 = evidence$5$1;
                this.t$2 = t$2;
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    public <T> Numeric sparklyr$Collectors$$extractNumericType(Object x, scala.math.Numeric<T> evidence$6, ClassTag<T> t) {
        None$ none$;
        if (x == null) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            Option option = t.unapply(x);
            if (!option.isEmpty() && option.get() instanceof Object) {
                Predef$ predef$ = Predef$.MODULE$;
                some = new Some((Object)BoxesRunTime.boxToDouble((double)evidence$6.toDouble(x)));
            } else {
                some = new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
            }
            none$ = some;
        }
        return new Numeric((Option<Object>)none$);
    }

    public Numeric collectBigDecimal(Row row, int idx) {
        return this.sparklyr$Collectors$$extractBigDecimal(row.apply(idx));
    }

    public Numeric[] collectBigDecimalArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Numeric[])((WrappedArray)arr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Numeric apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractBigDecimal(x);
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    public Numeric sparklyr$Collectors$$extractBigDecimal(Object x) {
        None$ none$;
        if (x == null) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            if (x instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)x;
                some = new Some((Object)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()));
            } else {
                some = new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
            }
            none$ = some;
        }
        return new Numeric((Option<Object>)none$);
    }

    public Function2<Row, Object, String> collectForceString() {
        return this.collectForceString;
    }

    public String[] collectForceStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (String[])((WrappedArray)arr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractStringRepr(x);
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String sparklyr$Collectors$$extractStringRepr(Object x) {
        return x == null ? "<NA>" : x.toString();
    }

    public Function2<Row, Object, String> collectString() {
        return this.collectString;
    }

    public String[] collectStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (String[])((WrappedArray)arr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractString(x);
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String sparklyr$Collectors$$extractString(Object x) {
        String string;
        String string2 = x instanceof String ? (string = (String)x) : "<NA>";
        return string2;
    }

    public Object collectVector(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el == null ? Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing()) : (el instanceof Seq ? ((Seq)el).toArray(ClassTag$.MODULE$.Any()) : el.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(el, new Object[0]));
        return object;
    }

    public Object collectJSON(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el instanceof String ? new StructTypeAsJSON((String)el) : this.collectDefault(row, idx);
        return object;
    }

    public Timestamp collectTimestamp(Row row, int idx) {
        return this.sparklyr$Collectors$$extractTimestamp(row.apply(idx));
    }

    public Timestamp[] collectTimestampArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Timestamp[])((WrappedArray)arr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Timestamp apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractTimestamp(x);
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public Timestamp sparklyr$Collectors$$extractTimestamp(Object x) {
        Timestamp timestamp;
        Timestamp timestamp2 = x instanceof Timestamp ? (timestamp = (Timestamp)x) : null;
        return timestamp2;
    }

    public Date collectDate(Row row, int idx) {
        return this.sparklyr$Collectors$$extractDate(row.apply(idx));
    }

    public Date[] collectDateArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Date[])((WrappedArray)arr.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Date apply(Object x) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractDate(x);
            }
        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Date.class)))).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Date sparklyr$Collectors$$extractDate(Object x) {
        Date date;
        Date date2 = x instanceof Date ? (date = (Date)x) : null;
        return date2;
    }

    public Object collectDefault(Row row, int idx) {
        return row.apply(idx);
    }

    public Collectors.ColumnCtx<? super Object> mkColumnCtx(String colType, int numRows) {
        Collectors.ColumnCtx columnCtx;
        if ("BooleanType".equals(colType)) {
            AnyValManifest anyValManifest = ManifestFactory$.MODULE$.Int();
            Serializable serializable = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Row row, int idx) {
                    return Collectors$.MODULE$.collectBoolean(row, idx);
                }
            };
            columnCtx = new Collectors.ColumnCtx(serializable, numRows, anyValManifest);
        } else if ("ByteType".equals(colType)) {
            AnyValManifest anyValManifest = ManifestFactory$.MODULE$.Int();
            Serializable serializable = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Row row, int idx) {
                    return Collectors$.MODULE$.collectIntegralType(row, idx, Numeric.ByteIsIntegral$.MODULE$, ClassTag$.MODULE$.Byte());
                }
            };
            columnCtx = new Collectors.ColumnCtx(serializable, numRows, anyValManifest);
        } else if ("ShortType".equals(colType)) {
            AnyValManifest anyValManifest = ManifestFactory$.MODULE$.Int();
            Serializable serializable = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Row row, int idx) {
                    return Collectors$.MODULE$.collectIntegralType(row, idx, Numeric.ShortIsIntegral$.MODULE$, ClassTag$.MODULE$.Short());
                }
            };
            columnCtx = new Collectors.ColumnCtx(serializable, numRows, anyValManifest);
        } else if ("IntegerType".equals(colType)) {
            columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Row row, int idx) {
                    return Collectors$.MODULE$.collectIntegralType(row, idx, Numeric.IntIsIntegral$.MODULE$, ClassTag$.MODULE$.Int());
                }
            }, (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("LongType".equals(colType)) {
            columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Numeric apply(Row row, int idx) {
                    return Collectors$.MODULE$.collectNumericType(row, idx, Numeric.LongIsIntegral$.MODULE$, ClassTag$.MODULE$.Long());
                }
            }, ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
        } else if ("Decimal".equals(colType)) {
            columnCtx = this.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
        } else {
            Option option = this.ReDecimalType().unapplySeq((CharSequence)colType);
            if (option.isEmpty()) {
                if ("FloatType".equals(colType)) {
                    columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Numeric apply(Row row, int idx) {
                            return Collectors$.MODULE$.collectNumericType(row, idx, Numeric.FloatIsFractional$.MODULE$, ClassTag$.MODULE$.Float());
                        }
                    }, ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
                } else if ("DoubleType".equals(colType)) {
                    columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Numeric apply(Row row, int idx) {
                            return Collectors$.MODULE$.collectNumericType(row, idx, Numeric.DoubleIsFractional$.MODULE$, ClassTag$.MODULE$.Double());
                        }
                    }, ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
                } else if ("StringType".equals(colType)) {
                    columnCtx = this.newColumnCtx$1(this.collectString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
                } else if ("TimestampType".equals(colType)) {
                    columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Timestamp apply(Row row, int idx) {
                            return Collectors$.MODULE$.collectTimestamp(row, idx);
                        }
                    }, ManifestFactory$.MODULE$.classType(Timestamp.class), numRows);
                } else if ("CalendarIntervalType".equals(colType)) {
                    columnCtx = this.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
                } else if ("DateType".equals(colType)) {
                    columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Date apply(Row row, int idx) {
                            return Collectors$.MODULE$.collectDate(row, idx);
                        }
                    }, ManifestFactory$.MODULE$.classType(Date.class), numRows);
                } else {
                    Option option2 = this.ReVectorType().unapplySeq((CharSequence)colType);
                    if (option2.isEmpty()) {
                        Option option3;
                        Option option4;
                        Option option5;
                        Option option6;
                        Option option7;
                        Option option8;
                        Option option9;
                        Option option10;
                        Option option11;
                        Option option12;
                        Option option13;
                        String string = StructTypeAsJSON$.MODULE$.DType();
                        columnCtx = !(string != null ? !string.equals(colType) : colType != null) ? this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectJSON(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.Any(), numRows) : ((option13 = this.ReBooleanArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option12 = this.ReByteArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option11 = this.ReShortArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option10 = this.ReIntegerArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option9 = this.ReLongArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option8 = this.ReDecimalArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option7 = this.ReFloatArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option6 = this.ReDoubleArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option5 = this.ReStringArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option4 = this.ReTimestampArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ((option3 = this.ReDateArrayType().unapplySeq((CharSequence)colType)).isEmpty() ? ("ArrayType(CalendarIntervalType,true)".equals(colType) ? this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectForceStringArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("ArrayType(CalendarIntervalType,false)".equals(colType) ? this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectForceStringArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("NullType".equals(colType) ? this.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectDefault(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.Any(), numRows)))) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Date[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectDateArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Date.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Timestamp[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectTimestampArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Timestamp.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectStringArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Numeric[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectNumericTypeArr(row, idx, Numeric.DoubleIsFractional$.MODULE$, ClassTag$.MODULE$.Double());
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Numeric[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectNumericTypeArr(row, idx, Numeric.FloatIsFractional$.MODULE$, ClassTag$.MODULE$.Float());
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Numeric[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectBigDecimalArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Numeric[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectNumericTypeArr(row, idx, Numeric.LongIsIntegral$.MODULE$, ClassTag$.MODULE$.Long());
                            }
                        }, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectIntegralTypeArr(row, idx, Numeric.IntIsIntegral$.MODULE$, ClassTag$.MODULE$.Int());
                            }
                        }, ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectIntegralTypeArr(row, idx, Numeric.ShortIsIntegral$.MODULE$, ClassTag$.MODULE$.Short());
                            }
                        }, ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectIntegralTypeArr(row, idx, Numeric.ByteIsIntegral$.MODULE$, ClassTag$.MODULE$.Byte());
                            }
                        }, ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows)) : this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int[] apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectBooleanArr(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows));
                    } else {
                        columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Row row, int idx) {
                                return Collectors$.MODULE$.collectVector(row, idx);
                            }
                        }, ManifestFactory$.MODULE$.Any(), numRows);
                    }
                }
            } else {
                columnCtx = this.newColumnCtx$1((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Numeric apply(Row row, int idx) {
                        return Collectors$.MODULE$.collectBigDecimal(row, idx);
                    }
                }, ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
            }
        }
        return columnCtx;
    }

    private final Collectors.ColumnCtx newColumnCtx$1(Function2 collector, Manifest evidence$8, int numRows$1) {
        return new Collectors.ColumnCtx(collector, numRows$1, evidence$8);
    }

    private Collectors$() {
        MODULE$ = this;
        Predef$ predef$ = Predef$.MODULE$;
        this.ReDecimalType = new StringOps("(^DecimalType(\\(.*\\)?)$)").r();
        Predef$ predef$2 = Predef$.MODULE$;
        this.ReVectorType = new StringOps("(.*VectorUDT.*)").r();
        Predef$ predef$3 = Predef$.MODULE$;
        this.ReBooleanArrayType = new StringOps("(^ArrayType\\(BooleanType,(true|false)\\)$)").r();
        Predef$ predef$4 = Predef$.MODULE$;
        this.ReByteArrayType = new StringOps("(^ArrayType\\(ByteType,(true|false)\\)$)").r();
        Predef$ predef$5 = Predef$.MODULE$;
        this.ReShortArrayType = new StringOps("(^ArrayType\\(ShortType,(true|false)\\)$)").r();
        Predef$ predef$6 = Predef$.MODULE$;
        this.ReIntegerArrayType = new StringOps("(^ArrayType\\(IntegerType,(true|false)\\)$)").r();
        Predef$ predef$7 = Predef$.MODULE$;
        this.ReLongArrayType = new StringOps("(^ArrayType\\(LongType,(true|false)\\)$)").r();
        Predef$ predef$8 = Predef$.MODULE$;
        this.ReDecimalArrayType = new StringOps("(^ArrayType\\(DecimalType(\\(.*\\)?),(true|false)\\)$)").r();
        Predef$ predef$9 = Predef$.MODULE$;
        this.ReFloatArrayType = new StringOps("(^ArrayType\\(FloatType,(true|false)\\)$)").r();
        Predef$ predef$10 = Predef$.MODULE$;
        this.ReDoubleArrayType = new StringOps("(^ArrayType\\(DoubleType,(true|false)\\)$)").r();
        Predef$ predef$11 = Predef$.MODULE$;
        this.ReStringArrayType = new StringOps("(^ArrayType\\(StringType,(true|false)\\)$)").r();
        Predef$ predef$12 = Predef$.MODULE$;
        this.ReTimestampArrayType = new StringOps("(^ArrayType\\(TimestampType,(true|false)\\)$)").r();
        Predef$ predef$13 = Predef$.MODULE$;
        this.ReDateArrayType = new StringOps("(^ArrayType\\(DateType,(true|false)\\)$)").r();
        this.collectForceString = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row, int idx) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractStringRepr(row.apply(idx));
            }
        };
        this.collectString = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row, int idx) {
                return Collectors$.MODULE$.sparklyr$Collectors$$extractString(row.apply(idx));
            }
        };
    }
}

