/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sparklyr.BackendHandler;
import sparklyr.JVMObjectTracker;
import sparklyr.Logger;
import sparklyr.Serializer;
import sparklyr.Utils$;

@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0004\t\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!1\u0003A!A!\u0002\u00139\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b9\u0002A\u0011A\u0018\t\rU\u0002\u0001\u0015)\u00037\u0011\u0019\u0001\u0005\u0001)Q\u0005\u0003\"1a\t\u0001Q!\n\u001dCaA\u0013\u0001!B\u0013Y\u0005BB*\u0001A\u0003&A\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0003d\u0001\u0011\u0005A\rC\u0003r\u0001\u0011\u0005!\u000fC\u0003t\u0001\u0011\u0005!O\u0001\bCC\u000e\\WM\u001c3DQ\u0006tg.\u001a7\u000b\u0003E\t\u0001b\u001d9be.d\u0017P]\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0007Y><w-\u001a:\u0011\u0005qiR\"\u0001\t\n\u0005y\u0001\"A\u0002'pO\u001e,'/A\u0005uKJl\u0017N\\1uKB\u0019Q#I\u0012\n\u0005\t2\"!\u0003$v]\u000e$\u0018n\u001c81!\t)B%\u0003\u0002&-\t!QK\\5u\u0003)\u0019XM]5bY&TXM\u001d\t\u00039!J!!\u000b\t\u0003\u0015M+'/[1mSj,'/A\u0004ue\u0006\u001c7.\u001a:\u0011\u0005qa\u0013BA\u0017\u0011\u0005AQe+T(cU\u0016\u001cG\u000f\u0016:bG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0006aE\u00124\u0007\u000e\t\u00039\u0001AQAG\u0003A\u0002mAQaH\u0003A\u0002\u0001BQAJ\u0003A\u0002\u001dBQAK\u0003A\u0002-\nQb\u00195b]:,GNR;ukJ,\u0007CA\u001c?\u001b\u0005A$BA\u001d;\u0003\u001d\u0019\u0007.\u00198oK2T!a\u000f\u001f\u0002\u000b9,G\u000f^=\u000b\u0003u\n!![8\n\u0005}B$!D\"iC:tW\r\u001c$viV\u0014X-A\u0005c_>$8\u000f\u001e:baB\u0011!\tR\u0007\u0002\u0007*\u0011\u0001IO\u0005\u0003\u000b\u000e\u0013qbU3sm\u0016\u0014(i\\8ugR\u0014\u0018\r]\u0001\nE>\u001c8o\u0012:pkB\u0004\"a\u000e%\n\u0005%C$AD#wK:$Hj\\8q\u000fJ|W\u000f]\u0001\fS:,G/\u00113ee\u0016\u001c8\u000f\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006\u0019a.\u001a;\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018a\u00035pgR\u001cuN\u001c;fqR\u0004\"!\u0016/\u000f\u0005YS\u0006CA,\u0017\u001b\u0005A&BA-\u0013\u0003\u0019a$o\\8u}%\u00111LF\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\-\u0005q1/\u001a;I_N$8i\u001c8uKb$HCA\u0012b\u0011\u0015\u00117\u00021\u0001U\u0003AAwn\u001d;D_:$X\r\u001f;QCJ\fW.\u0001\u0003j]&$H\u0003B3i[>\u0004\"!\u00064\n\u0005\u001d4\"aA%oi\")\u0011\u000e\u0004a\u0001U\u00061!/Z7pi\u0016\u0004\"!F6\n\u000514\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006]2\u0001\r!Z\u0001\u0005a>\u0014H\u000fC\u0003q\u0019\u0001\u0007!.A\teKR,'/\\5oSN$\u0018n\u0019)peR\f1A];o)\u0005\u0019\u0013!B2m_N,\u0007")
public class BackendChannel {
    private final Logger logger;
    private final Function0<BoxedUnit> terminate;
    private final Serializer serializer;
    private final JVMObjectTracker tracker;
    private ChannelFuture channelFuture;
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private InetSocketAddress inetAddress;
    private String hostContext;

    public void setHostContext(String hostContextParam) {
        this.hostContext = hostContextParam;
    }

    public int init(boolean remote, int port, boolean deterministicPort) {
        if (remote) {
            byte[] anyIpAddress = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
            InetAddress anyInetAddress = InetAddress.getByAddress(anyIpAddress);
            int channelPort = deterministicPort ? Utils$.MODULE$.nextPort(port, anyInetAddress) : 0;
            this.logger.log(new StringBuilder(34).append("is using port ").append(channelPort).append(" for backend channel").toString());
            this.inetAddress = new InetSocketAddress(anyInetAddress, channelPort);
        } else {
            int channelPort = deterministicPort ? Utils$.MODULE$.nextPort(port, InetAddress.getLoopbackAddress()) : 0;
            this.logger.log(new StringBuilder(34).append("is using port ").append(channelPort).append(" for backend channel").toString());
            this.inetAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), channelPort);
        }
        SparkConf conf = new SparkConf();
        EventLoopGroup workerGroup = this.bossGroup = new NioEventLoopGroup(conf.getInt("sparklyr.backend.threads", 10));
        BackendHandler handler = new BackendHandler((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close(), this.logger, this.hostContext, this.serializer, this.tracker);
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, workerGroup).channel(NioServerSocketChannel.class);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(null, handler){
            private final BackendHandler handler$1;

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast("encoder", (ChannelHandler)new ByteArrayEncoder()).addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)).addLast("decoder", (ChannelHandler)new ByteArrayDecoder()).addLast("handler", (ChannelHandler)this.handler$1);
            }
            {
                this.handler$1 = handler$1;
            }
        });
        this.channelFuture = this.bootstrap.bind((SocketAddress)this.inetAddress);
        this.channelFuture.syncUninterruptibly();
        return ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
    }

    public void run() {
        this.channelFuture.channel().closeFuture().syncUninterruptibly();
    }

    public void close() {
        this.terminate.apply$mcV$sp();
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        Object object = this.bootstrap != null && this.bootstrap.group() != null ? this.bootstrap.group().shutdownGracefully() : BoxedUnit.UNIT;
        Object object2 = this.bootstrap != null && this.bootstrap.childGroup() != null ? this.bootstrap.childGroup().shutdownGracefully() : BoxedUnit.UNIT;
        this.bootstrap = null;
    }

    public BackendChannel(Logger logger, Function0<BoxedUnit> terminate, Serializer serializer, JVMObjectTracker tracker) {
        this.logger = logger;
        this.terminate = terminate;
        this.serializer = serializer;
        this.tracker = tracker;
        this.channelFuture = null;
        this.bootstrap = null;
        this.bossGroup = null;
        this.inetAddress = null;
        this.hostContext = null;
    }
}

