/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.fixed.FixedWidthFieldLengths;
import com.univocity.parsers.fixed.FixedWidthFormat;

public class FixedWidthParserSettings
extends CommonParserSettings<FixedWidthFormat> {
    protected boolean skipTrailingCharsUntilNewline = false;
    protected boolean recordEndsOnNewline = false;
    private final FixedWidthFieldLengths fieldLengths;

    public FixedWidthParserSettings(FixedWidthFieldLengths fieldLengths) {
        if (fieldLengths == null) {
            throw new IllegalArgumentException("Field lengths cannot be null");
        }
        this.fieldLengths = fieldLengths;
        String[] names = fieldLengths.getFieldNames();
        if (names != null) {
            this.setHeaders(names);
        }
    }

    int[] getFieldLengths() {
        return this.fieldLengths.getFieldLengths();
    }

    public boolean getSkipTrailingCharsUntilNewline() {
        return this.skipTrailingCharsUntilNewline;
    }

    public void setSkipTrailingCharsUntilNewline(boolean skipTrailingCharsUntilNewline) {
        this.skipTrailingCharsUntilNewline = skipTrailingCharsUntilNewline;
    }

    public boolean getRecordEndsOnNewline() {
        return this.recordEndsOnNewline;
    }

    public void setRecordEndsOnNewline(boolean recordEndsOnNewline) {
        this.recordEndsOnNewline = recordEndsOnNewline;
    }

    @Override
    protected FixedWidthFormat createDefaultFormat() {
        return new FixedWidthFormat();
    }

    @Override
    protected CharAppender newCharAppender() {
        return new DefaultCharAppender(this.getMaxCharsPerColumn(), this.getNullValue(), ((FixedWidthFormat)this.getFormat()).getPadding());
    }

    @Override
    public int getMaxCharsPerColumn() {
        int max = super.getMaxCharsPerColumn();
        int minimum = 0;
        for (int length : this.getFieldLengths()) {
            minimum += length + 2;
        }
        return max > minimum ? max : minimum;
    }

    @Override
    public int getMaxColumns() {
        int minimum;
        int max = super.getMaxColumns();
        return max > (minimum = this.getFieldLengths().length) ? max : minimum;
    }
}

