% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_operations.R
\name{stream_generate_test}
\alias{stream_generate_test}
\title{Generate Test Stream}
\usage{
stream_generate_test(df = rep(1:1000), path = "source",
  distribution = floor(10 + 1e+05 * stats::dbinom(1:20, 20, 0.5)),
  iterations = 50, interval = 1)
}
\arguments{
\item{df}{The data frame used as a source of rows to the stream, will
be cast to data frame if needed. Defaults to a sequence of one thousand
entries.}

\item{path}{Path to save stream of files to, defaults to \code{"source"}.}

\item{distribution}{The distribution of rows to use over each iteration,
defaults to a binomial distribution. The stream will cycle through the
distribution if needed.}

\item{iterations}{Number of iterations to execute before stopping, defaults
to fifty.}

\item{interval}{The inverval in seconds use to write the stream, defaults
to one second.}
}
\description{
Generates a local test stream, useful when testing streams locally.
}
\details{
This function requires the \code{callr} package to be installed.
}
