/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.tsv;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.tsv.TsvFormat;
import com.univocity.parsers.tsv.TsvWriterSettings;
import java.io.Writer;

public class TsvWriter
extends AbstractWriter<TsvWriterSettings> {
    private final boolean ignoreLeading;
    private final boolean ignoreTrailing;
    private final char escapeChar;

    public TsvWriter(Writer writer, TsvWriterSettings settings) {
        super(writer, settings);
        this.escapeChar = ((TsvFormat)settings.getFormat()).getEscapeChar();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (i != 0) {
                this.appendToRow('\t');
            }
            String nextElement = this.getStringValue(row[i]);
            int originalLength = this.appender.length();
            this.append(nextElement);
            if (this.appender.length() == originalLength && this.nullValue != null && !this.nullValue.isEmpty()) {
                this.append(this.nullValue);
            }
            this.appendValueToRow();
        }
    }

    private void append(String element) {
        if (element == null) {
            element = this.nullValue;
        }
        if (element == null) {
            return;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = this.skipLeadingWhitespace(element);
        }
        if (this.ignoreTrailing) {
            for (int i = start; i < element.length(); ++i) {
                char ch = element.charAt(i);
                if (ch == '\t') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('t');
                    continue;
                }
                if (ch == '\n') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('n');
                    continue;
                }
                if (ch == '\\') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('\\');
                    continue;
                }
                if (ch == '\r') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('r');
                    continue;
                }
                this.appender.appendIgnoringWhitespace(ch);
            }
        } else {
            for (int i = start; i < element.length(); ++i) {
                char ch = element.charAt(i);
                if (ch == '\t') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('t');
                    continue;
                }
                if (ch == '\n') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('n');
                    continue;
                }
                if (ch == '\\') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('\\');
                    continue;
                }
                if (ch == '\r') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('r');
                    continue;
                }
                this.appender.append(ch);
            }
        }
    }
}

